/*
   File:    XMPShell.h

   Contains:   definition of XMPShell class

   Written by: Tantek elik

   Copyright:   1993-94 by Apple Computer, Inc., all rights reserved.

   Change History (most recent first):

      <38>   2/15/94 T    fix #1144029 and some cleanup
      <37>    2/4/94 T    fixes to compile with PPC Universal headers
      <36>    2/2/94 T    added CreateUntitledContainer
      <35>   1/31/94 NP    Changed parameter to coercion handler to
                           conform to new interface.
      <34>   1/25/94 NP    T: changed OpenDraft and CloseDraft to
                           take a XMPDraft* parameter.   NP: Added
                           GetAEError and SetAEError and associated
                           field.
      <33>   1/20/94 RR    Removed WasAOCEMailerEvent
      <32>   1/19/94 eeh      added Open Document menu item
      <31>   1/18/94 T    use kOpenDocShellSignature
      <30>   1/17/94 NP    Semantic Events callbacks API changes.
      <29>   1/14/94 T    removed obsolete InitializeDraftProperties
      <28>   1/13/94 eeh      integrate AOCEObj
      <27>   1/13/94 NP    Private members for Undo implementation.
      <26>   1/11/94 eeh      make mailer menu heierarchical
      <25>   1/10/94 NP    Added private member function.
      <24>  12/15/93 T    fix kXMPMenuShowPartsBin   =  14
      <23>  12/13/93 RR    Added kXMPMenuAbout
      <22>   12/9/93 eeh      Save and CloseWindow made
                           private-by-convention, params added to
                           DoesUserCancelClose and SaveAs for
                           scripting
      <21>   12/3/93 CC    Added ExportClipboard() method.
      <20>  11/18/93 CG    Added #define kDocShellCreator for 'jedi'
      <19>  11/16/93 RR    Completely reorganized event handling
      <18>  11/15/93 eeh      added ManageMailerSave and SaveMailerHere
      <17>  10/27/93 eeh      added self param to GetFSSpecFromLetter
      <16>  10/20/93 EH    added CoerceToFSSpec() and
                           fAlreadyInCoercion.
      <15>  10/19/93 CG    Changed destructor from XMPVMethod to
                           virtual for ASLM building.
      <14>  10/18/93 T    reduced external entrypoints to XMPShell
                           object to one (used to have Initialize()
                           and Run(), now all you do is go())
      <13>  10/18/93 CG    Added ASLM support for XMPShell.
      <12>  10/12/93 EH    More changes for mailer support
      <11>   10/7/93 EH    Various changes related to adding Mailer
                           support, with more to come.
      <10>   9/29/93 T    added SaveDraft() to do
                           fWindowState->Externalize(fDraft); and
                           fDraft->Externalize();
       <9>   9/24/93 T    added XMPMenuBar* fMenuBar
       <8>   9/22/93 NP    Integrate Semantic Events into the
                           DocShell.
       <7>   9/15/93 T    added new methods for Error Handling
       <6>   8/27/93 T    added new CreateTempContainer
       <5>   8/24/93 T    removed obsolete function definitions,
                           added more functions for HI changes
       <4>   8/20/93 T    integrated with Prototype Window, Layout,
                           Imaging and parts
       <3>   8/19/93 T    integration
      <10>   7/21/93 T    with help from CG: defined methods for OAPP & QUIT AppleEvents
       <1>    7/6/93 T    first checked in
       <8>    7/6/93 T    _SHELLM_
       <7>    7/6/93 T    define Draft Interface
       <6>   5/24/93 T    finish defining methods for open, save,
                           close, save as, and revert
       <5>   4/30/93 T    define methods for Open
       <4>   4/29/93 T    change names of includefiles
       <3>   4/28/93 T    define more methods for the Event Loop
       <2>   4/27/93 T    defined Initialization, Main Event Loop.
                           made XMPShell a root class
       <1>   4/14/93 T    first checked in

   To Do:
*/


#ifndef _SHELLM_
#define _SHELLM_

#ifdef UICL
/*+--------------------------------------------------------------------------+*/
/*| Include headers for the User Interface Class Library                     |*/
/*+--------------------------------------------------------------------------+*/
#include <iapp.hpp>           // IApplication
#include <iframe.hpp>         /* IFrameWindow                */
#include <ireslib.hpp>        // IResourceLibrary/IResourceId
#include <itrace.hpp>         // ITrace
#include <imsgbox.hpp>
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _DRAFT_
#include "Draft.h"         // for XMPDraftPermissions
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   The Shell contains all code which interfaces a particular platform's
   user interface with the OpenDoc parts underneath.  
   Each document is run in its own process.

*/

//==============================================================================
// Constants
//==============================================================================


//-------------------------------------------------------------------------------------
// Menus
//-------------------------------------------------------------------------------------

enum {
   kXMPFileMenuRes         =  129
   ,kXMPEditMenuRes     =  130
   ,kXMPOCEFileMenuRes     =  193
   ,kXMPOCEMailerMenuID =  194
};

#define  kXMPMenuAbout  1

typedef enum {
   kXMPMenuNew       =  1
   ,kXMPMenuOpen
   ,kXMPMenuOpenDocument
   ,kXMPMenuInsert
   ,kXMPMenuClose

   // blank line goes here

   ,kXMPMenuSave     =  7
   ,kXMPMenuSaveACopy
   ,kXMPMenuRevert
   ,kXMPMenuDraft
   
   // blank line goes here

   // Mail menu goes here -- sometimes -- but doesn't need an enum 'cause
   // it's hierarchical
   
   // blank line goes here *IF MAIL ITEM IS PRESENT*
   
   ,kXMPMenuPageSetup   =  14
   ,kXMPMenuPrint

   // blank line goes here

   ,kXMPMenuShowPartsBin   =  17
};

   // use this value to calculate the real locations of menuitems below Mail
   // in the case where AOCE isn't installed and the Mail item isn't present.
const short kXMPMailerMenuOffset = 2;

enum {                     // for use when mailer menu is a submenu
   kXMPMenuAddDeleteAOCEMailer   =  1
   ,kXMPMenuExpandAOCEMailer           // <eeh>$$$$$ just for debugging!
   ,kXMPMenuContractAOCEMailer            // <eeh>$$$$$ just for debugging!

   // blank line goes here

   ,kXMPMenuSendMail =  5

   // blank line goes here

   ,kXMPMenuForwardMail =  7
   ,kXMPMenuReplyToMail
   ,kXMPMenuReplyToAllMail
};

typedef enum {
   kXMPMenuUndo      =  1
   ,kXMPMenuRedo
   
   ,kXMPMenuCut      =  4
   ,kXMPMenuCopy
   ,kXMPMenuPaste
   ,kXMPMenuPasteAs
   ,kXMPMenuClear
   ,kXMPMenuSelectAll
   
   ,kXMPMenuGetPartInfo=   11
   ,kXMPMenuPreferences
   ,kXMPMenuViewAsWin
};

 
//-------------------------------------------------------------------------------------
// Dialogs
//-------------------------------------------------------------------------------------

const XMPSShort   kXMPscOK = 1;                 //OK button
const XMPSShort   kXMPscCancel = 2;             //Cancel button
const XMPSShort   kXMPscNo = 3;                 //no, don't save


//-------------------------------------------------------------------------------------
// OSType constants
//-------------------------------------------------------------------------------------

const DescType kXMPShellPropAccessor      = 0x73706163;  // 'spac';
const DescType kXMPShellSelfPropAccessor  = 0x7368656C;  // 'shel';
const OSType kXMPOpenDocLetterType     = 0x626C7472;  // 'bltr';

//==============================================================================
// Scalar Types
//==============================================================================

typedef  XMPSShort   XMPResNumber;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPShell;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPSession;
class XMPDispatcher;
class XMPWindowState;
class XMPArbitrator;
class XMPDraft;
class XMPDocument;
class XMPContainer;
class XMPMenuBar;
class XMPSemanticInterface;
class XMPFile;

//==============================================================================
// XMPShell
//==============================================================================

#define kXMPShellID "appl:xmpshell$class,1.0.0"

#ifdef UICL
class IClient;
#else
extern "C" {
   MRESULT EXPENTRY ODShellWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
}
#endif

class XMPShell
{  
public:
#ifdef UICL
   friend IClient;        // CED - Allow client wnd proc to call DispatchEvent
#else
   friend MRESULT ODShellWndProc(HWND, ULONG, MPARAM, MPARAM);
#endif

//-------------------------------------------------------------------------------------
// Constructor/Destructor
//-------------------------------------------------------------------------------------

   XMPShell();
   virtual ~XMPShell();

//-------------------------------------------------------------------------------------
// Main Entry Point
//-------------------------------------------------------------------------------------

   XMPVMethod void go( char * );

//-------------------------------------------------------------------------------------
// Memory Management
//-------------------------------------------------------------------------------------

   XMPVMethod  XMPSize  Purge(XMPSize size);

//-------------------------------------------------------------------------------------
// Session Management
//-------------------------------------------------------------------------------------

   XMPMethod XMPSession* GetSession(); 


//-------------------------------------------------------------------------------------
// public for AppleEvent handlers, but private by convention
//-------------------------------------------------------------------------------------
   XMPMethod void Save(XMPFile* file);    

   XMPMethod void CloseWindow(XMPPlatformWindow window, XMPFile* file, 
         DescType saveOptions);

   XMPMethod   void SetAEError(XMPError error);

protected:

//-------------------------------------------------------------------------------------
// Initialization
//-------------------------------------------------------------------------------------

   XMPMethod void Initialize();  
   XMPMethod void InitPlatform();
   XMPMethod void InstallMenuBar();

//-------------------------------------------------------------------------------------
// Main Event Loop
//-------------------------------------------------------------------------------------

   XMPMethod XMPBoolean ContinueEventLoop();
#ifndef PLATFORM_OS2   
   XMPMethod void          DispatchEvent(XMPEventData event);
#else
   XMPMethod XMPBoolean    DispatchEvent(XMPEventData event);
#endif
   XMPMethod void          DispatchMouseDownEvent(XMPEventData event);
   XMPMethod void          DispatchMouseUpEvent(XMPEventData event);
   XMPMethod XMPBoolean    DispatchMenuEvent(XMPEventData event);
   XMPMethod void          DispatchKeyDownEvent(XMPEventData event);
   
// XMPMethod void          HandleNullEvent(XMPEventData event);
// XMPMethod void          HandleKeyDownEvent(XMPEventData event);
// XMPMethod void          HandleKeyUpEvent(XMPEventData event);
// XMPMethod void          HandleAutoKeyEvent(XMPEventData event);
// XMPMethod void          HandleUpdateEvent(XMPEventData event);
// XMPMethod void          HandleDiskEvent(XMPEventData event);
// XMPMethod void          HandleActivateEvent(XMPEventData event);
   XMPMethod void          HandleOSEvent(XMPEventData event);  
   XMPMethod void          HandleHighLevelEvent(XMPEventData event);
// XMPMethod void          HandleUnknownEvent(XMPEventData event);
   
   XMPMethod void       HandleMenuCommand(XMPSLong menuResult, XMPEventData event);
   XMPMethod void          HandleMouseDownInWindow(WindowPtr window, XMPSShort partcode, XMPEventData event);
   XMPMethod void          HandleMouseUpInWindow(WindowPtr window, XMPSShort partcode, XMPEventData event);
   XMPMethod void       HandleMouseDownInCloseBox(WindowPtr window, XMPEventData event);
   XMPMethod void       HandleMouseDownInDragRegion(WindowPtr window, XMPEventData event);
   XMPMethod void       HandleMouseDownInGrowBox(WindowPtr window, XMPEventData event);
   XMPMethod void       HandleMouseDownInZoomBox(WindowPtr window, XMPSShort partcode, XMPEventData event);

   XMPMethod void       ExportClipboard();

//-------------------------------------------------------------------------------------
// New
//-------------------------------------------------------------------------------------

   XMPMethod XMPFile* New();     
      // create a new document with the same part as the root part of the active window
      // and launch it with a new shell
      
   XMPMethod XMPFileSpec   CreateTempContainer(XMPDocument** documentPtr,
         XMPContainer** containerPtr);

   XMPMethod XMPFile* CreateTempFile(XMPOSType creator, XMPOSType fileType);

   XMPMethod XMPFileSpec   CreateUntitledContainer(XMPDocument** documentPtr,
         XMPContainer** containerPtr, XMPFile* currentFile);

//-------------------------------------------------------------------------------------
// Open
//-------------------------------------------------------------------------------------

   XMPMethod void OpenFile(XMPFile* file);
   
   XMPMethod void OpenAnotherFile(XMPFile*   file);

   XMPMethod void Open();

   XMPMethod void OpenDraft(XMPDraft* draft);

   XMPMethod XMPFile*   XMPShell::OpenUntitled( const char *, const char *);
//JYS: add an extra parameter specifying the file name

   XMPMethod XMPDraft*  GetDraft() {return fDraft;};

   XMPMethod void OpenStdFile();

//-------------------------------------------------------------------------------------
// Close
//-------------------------------------------------------------------------------------

   XMPMethod void Close(); 

   XMPMethod XMPBoolean DoesUserCancelClose(XMPFile* file,
         DescType saveOptions);  

   XMPMethod void CloseDraft(XMPDraft* draft);

   XMPMethod void DeleteContainer(XMPContainer* container);
   
//-------------------------------------------------------------------------------------
// Save
//-------------------------------------------------------------------------------------

   XMPMethod XMPBoolean SaveAs(XMPFile* file);     

   XMPMethod void SaveACopy();      

   XMPMethod void SaveDraft();

//-------------------------------------------------------------------------------------
// Revert
//-------------------------------------------------------------------------------------

   XMPMethod   void  Revert();   

   XMPMethod   XMPBoolean  DoesUserOKRevert();  
      
//-------------------------------------------------------------------------------------
// Drafts
//-------------------------------------------------------------------------------------

   XMPMethod   void     Drafts();   

   XMPMethod   XMPBoolean  HasWriteAccess();
   
//-------------------------------------------------------------------------------------
// Parts Bin
//-------------------------------------------------------------------------------------

   XMPMethod   void  ShowPartsBin();   
   
//-------------------------------------------------------------------------------------
// AddNewMailer, RemoveMailer and SendMail
//-------------------------------------------------------------------------------------
   XMPMethod   void  SendMail();
   XMPMethod   void  ManageMailerSave(XMPUShort saveType);
   XMPMethod   void  SaveMailerHere(XMPFileSpec* usersFileSpec,
      XMPUShort saveType);

//-------------------------------------------------------------------------------------
// Update menus
//-------------------------------------------------------------------------------------

   XMPMethod   void  UpdateMenus();
   XMPMethod   void  UpdateUndoMenus();
   XMPMethod void ResetUndoText(MenuHandle editMenu);
   XMPMethod void    ResetRedoText(MenuHandle editMenu);
   XMPMethod void    SetMenuItemScript(MenuHandle menu, short itemNum,
                                 short scriptID);

//-------------------------------------------------------------------------------------
// Window Utility
//-------------------------------------------------------------------------------------

   XMPMethod   XMPBoolean  IsPalette(XMPPlatformWindow window);
   
   XMPMethod   XMPPlatformWindow GetFrontMost();

//-------------------------------------------------------------------------------------
// Error Handling
//-------------------------------------------------------------------------------------

   XMPMethod   void     ExceptionAlert(XMPError exceptionCode);

   XMPMethod   XMPBoolean  SearchErrTable(   XMPError value,
                                 XMPResNumber resourceID,
                                 Str255 str);

   XMPMethod   XMPBoolean  LookupErrString(XMPError value,
                                    XMPResNumber resourceID,
                                    Str255 str);

   XMPMethod   XMPSShort   MacAppAlert(XMPResNumber alertID);
   XMPMethod   XMPError GetAEError();

//-------------------------------------------------------------------------------------
// Apple Event Support
//-------------------------------------------------------------------------------------

   XMPMethod void InitAE();
   
   static XMPError HandleOpenAppEvent(XMPPart*  thePart,
                     AppleEvent* message,
                     AppleEvent* reply,
                     XMPSLong    refCon);
                     
   static XMPError HandleOpenDocsEvent(   XMPPart* thePart,
                        AppleEvent* message,
                        AppleEvent* reply,
                        XMPSLong    refCon);
                                 
   static XMPError HandlePrintDocsEvent(  XMPPart* thePart,
                        AppleEvent* message,
                        AppleEvent* reply,
                        XMPSLong    refCon);
                                    
   static XMPError HandleQuitEvent( XMPPart* thePart,
                     AppleEvent* message,
                     AppleEvent* reply,
                     XMPSLong    refCon);
                              
   static XMPError CoerceToFSSpec(XMPPart* thePart,
                        AEDesc* theAEDesc,
                        DescType toType,
                        XMPSLong handlerRefCon,
                        AEDesc* result);

   static OSErr GetFSSpecFromLetter(XMPShell* self, AEDesc* theData,
         AEDesc* result);

   static XMPError HandleGetTerminology(XMPPart*   thePart,
                        AppleEvent* message,
                        AppleEvent* reply,
                        XMPSLong refCon);

   void  InstallObjectAccessors(XMPSemanticInterface* theSI);
   void  InstallEventHandlers(XMPSemanticInterface* theSI);

//-------------------------------------------------------------------------------------
// Apple Event Support
//-------------------------------------------------------------------------------------

   void  SaveUndoAndRedoMenuItems(MenuHandle editMenu);

//-------------------------------------------------------------------------------------
// private fields
//-------------------------------------------------------------------------------------

   struct MenuItemInfo
   {
      Str255   text;
      short cmdChar;
      short iconID;
      short markChar;
      Style textStyle;
   };

   XMPSession*    fSession;
   XMPDispatcher*    fDispatcher;
   XMPWindowState*   fWindowState;
   XMPArbitrator*    fArbitrator;
   XMPContainer*  fContainer;
   XMPDocument*   fDocument;
   XMPDraft*      fDraft;
   XMPMenuBar*    fMenuBar;
   XMPBoolean     fIsNew; 
   XMPBoolean     fAOCEInstalled;
   XMPDraftPermissions fPermissions;
   XMPBoolean     fAlreadyInCoercion;
   XMPFile*    fAOCEFile;
   MenuItemInfo   fDefaultUndoMenuItem;
   MenuItemInfo   fDefaultRedoMenuItem;
   XMPError    fErrorFromOpenEvents;

};



#endif   // _SHELLM_
