/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    ShapePvM.h

  Contains:  Private subclasses of XMPShape (the ones that do the real work)

  Written by:  Jens Alfke

*/


#ifndef _SHAPEPVM_
#define _SHAPEPVM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

#ifndef _SHAPE_
#include "Shape.h"      // for XMPGeometryMode type
#endif

#define INCL_GPI
#include <os2.h>

#define  RgnHandle HRGN

typedef enum {
  kShapeIntersection,
  kShapeUnion,
  kShapeDifference,
  
  kShapeNoOp = -1
} XMPShapeOp; 


//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPShape;
struct XMPPolygon;

//==============================================================================
// XMPRealShape
//==============================================================================

class XMPRealShape :public XMPObject {
  public:
  
  XMPRealShape( XMPGeometryMode );
  virtual ~XMPRealShape( );

  XMPVMethod XMPSize       Purge(XMPSize size);      // override from XMPObject
  
  XMPMethod void        SetGeometryMode( XMPGeometryMode );
  XMPMethod XMPGeometryMode  GetGeometryMode( );

  XMPVMethod XMPRealShape*  SetPolygon( XMPPolygon* );

  XMPMethod XMPPlatformShape  GetPlatformShape( XMPGraphicsSystem );
  XMPVMethod void        SetPlatformShape( XMPGraphicsSystem, XMPPlatformShape );
  
  XMPVMethod XMPBoolean    HasGeometry( );
  
  XMPMethod void    WriteShape( XMPStorageUnit* )  { }    // Unused stubs
  XMPMethod XMPShape*  ReadShape( XMPStorageUnit* )  {return NULL;}
  XMPMethod void    CopyFrom( XMPShape* )      { }
  
  // Abstract stubs (these basically follow the XMPShape interface:)
  
  XMPVMethod void       GetBoundingBox( XMPRect *bounds )
    = 0;
  XMPVMethod XMPRealShape*   SetRectangle( XMPRect *rect )
    = 0;
  XMPVMethod XMPPolygon*     CopyPolygon( )
    = 0;
  XMPVMethod XMPBoolean    IsSameAs(XMPAbsShape* compareShape)
    = 0;
  XMPVMethod XMPBoolean    IsEmpty( )
    = 0;
  XMPVMethod XMPBoolean    ContainsPoint(XMPPoint point)
    = 0;
  XMPVMethod XMPBoolean    IsRectangular( )
    = 0;
  XMPVMethod XMPRealShape*  Transform(XMPTransform* transform)
    = 0;
  XMPVMethod XMPRealShape*  Copy( )
    = 0;
  XMPVMethod XMPRealShape*  Subtract(XMPShape* diffShape)
    = 0;
  XMPVMethod XMPRealShape*  Intersect(XMPShape* sectShape)
    = 0;
  XMPVMethod XMPRealShape*  Union(XMPShape* unionShape)
    = 0;
  
  XMPVMethod XMPRealShape*  Combine( XMPShapeOp, XMPShape* );
//JYS: Added the following member functions
//  HPS  GetHPS() const;
//  void  SetHPS(HPS hps);

  protected:
  
  // The following type points to Subtract, Intersect or Union methods:
//  typedef XMPRealShape* (XMPRealShape::*ShapeOpPtr)( XMPShape* );  $$$$$ Unused
  
  XMPVMethod XMPRealShape*  Clear( );        // Replace me with empty rect shape
  XMPMethod XMPRealShape*    Promote( XMPShapeOp =kShapeNoOp,
                     XMPShape*  =NULL);  // Convert & perform op
  
  XMPVMethod gxShape    CopyGXShape( )      // Return a GX shape
                = 0;  
  XMPVMethod void      InitQDRegion( )      // Called when fQDRegion needs to be set
                = 0;
  XMPVMethod void      FlushRgn( );      // Dispose region when shape changes
  
  XMPGeometryMode      fMode;          // Geometry mode
  RgnHandle        fQDRegion;        // Cached QuickDraw region

#if XMPDebug
  char          fType;          // Number identifying class type:
                          // 0=Rect, 1=Rgn, 2=Poly, 3=GX
#endif
};


class XMPRectShape :public XMPRealShape {
  public:
  
  XMPRectShape( XMPGeometryMode mode, const XMPRect& );
  
  XMPVMethod void      GetBoundingBox( XMPRect *bounds );
  XMPVMethod XMPRealShape*SetRectangle( XMPRect *rect );
  XMPVMethod XMPPolygon*  CopyPolygon( );

  XMPVMethod XMPBoolean  IsSameAs(XMPAbsShape* compareShape);
  XMPVMethod XMPBoolean  IsEmpty( );
  XMPVMethod XMPBoolean  ContainsPoint(XMPPoint point);
  XMPVMethod XMPBoolean  IsRectangular( );

  XMPVMethod void SetPlatformShape( XMPGraphicsSystem gs, XMPPlatformShape shape);
  
  XMPVMethod XMPRealShape*  Copy( );      // Really returns an XMPRectShape*

  XMPVMethod XMPRealShape*  Transform(XMPTransform* transform);
  XMPVMethod XMPRealShape*  Subtract(XMPShape* diffShape);
  XMPVMethod XMPRealShape*  Intersect(XMPShape* sectShape);
  XMPVMethod XMPRealShape*  Union(XMPShape* sectShape);
  
  protected:
  XMPVMethod void      InitQDRegion( );
  XMPVMethod gxShape    CopyGXShape( );
  XMPVMethod XMPRealShape*Clear( );        // Just clear w/o replacing

  private:
  XMPRect  fRect;
};


class XMPRgnShape :public XMPRealShape {
  public:
  
  XMPRgnShape( XMPGeometryMode mode );
  ~XMPRgnShape( );
  
  XMPVMethod XMPSize Purge(XMPSize size);      // Can't purge rgn!

  XMPVMethod void      GetBoundingBox( XMPRect *bounds );
  XMPVMethod XMPRealShape*SetRectangle( XMPRect *rect );
  XMPVMethod XMPPolygon*  CopyPolygon( );
  XMPVMethod XMPRealShape*SetPolygon( XMPPolygon* );

  XMPVMethod XMPBoolean  IsSameAs(XMPAbsShape* compareShape);
  XMPVMethod XMPBoolean  IsEmpty( );
  XMPVMethod XMPBoolean  ContainsPoint(XMPPoint point);
  XMPVMethod XMPBoolean  IsRectangular( );
  XMPVMethod XMPBoolean  HasGeometry( );
  
  XMPVMethod void        SetPlatformShape( XMPGraphicsSystem, XMPPlatformShape );
  XMPVMethod XMPRealShape*  Copy( );        // Really returns an XMPRgnShape*

  XMPVMethod XMPRealShape*  Transform(XMPTransform* transform);
  XMPVMethod XMPRealShape*  Subtract(XMPShape* diffShape);
  XMPVMethod XMPRealShape*  Intersect(XMPShape* sectShape);
  XMPVMethod XMPRealShape*  Union(XMPShape* sectShape);
  
  protected:
  XMPVMethod void      InitQDRegion( );
  XMPVMethod void      FlushRgn( );      // Never flush it!
  XMPVMethod gxShape    CopyGXShape( );
  
  virtual XMPRealShape*  Clear( );        // Just clear w/o replacing

};

//JYS: Commented out GX stuff
#if 0
class XMPGXShape :public XMPRealShape {
  public:
  XMPGXShape( XMPGeometryMode );
  ~XMPGXShape( );
  
  XMPVMethod void        GetBoundingBox( XMPRect *bounds );
  XMPVMethod XMPRealShape*  SetRectangle( XMPRect *rect );
  XMPVMethod XMPPolygon*    CopyPolygon( );
  XMPVMethod XMPRealShape*  SetPolygon( XMPPolygon* );
  XMPVMethod void        SetPlatformShape( XMPGraphicsSystem, XMPPlatformShape );

  XMPVMethod XMPBoolean  IsSameAs(XMPAbsShape* compareShape);
  XMPVMethod XMPBoolean  IsEmpty( );
  XMPVMethod XMPBoolean  ContainsPoint(XMPPoint point);
  XMPVMethod XMPBoolean  IsRectangular( );
  
  XMPVMethod XMPRealShape*  Copy( );        // Really returns an XMPGXShape*

  XMPVMethod XMPRealShape*  Transform(XMPTransform* transform);
  XMPVMethod XMPRealShape*  Subtract(XMPShape* diffShape);
  XMPVMethod XMPRealShape*  Intersect(XMPShape* sectShape);
  XMPVMethod XMPRealShape*  Union(XMPShape* sectShape);
  
  protected:
  XMPVMethod void      InitQDRegion( );
  XMPVMethod gxShape    CopyGXShape( );

  private:
  gxShape  fGXShape;
  XMPRect fBounds;
};
#endif

class XMPPolygonShape :public XMPRealShape {
  public:
  XMPPolygonShape( XMPGeometryMode );
  ~XMPPolygonShape( );
  
  XMPVMethod void        GetBoundingBox( XMPRect *bounds );
  XMPVMethod XMPRealShape*  SetRectangle( XMPRect *rect );
  XMPVMethod XMPPolygon*    CopyPolygon( );
  XMPVMethod XMPRealShape*  SetPolygon( XMPPolygon* );

  XMPVMethod XMPBoolean  IsSameAs(XMPAbsShape* compareShape);
  XMPVMethod XMPBoolean  IsEmpty( );
  XMPVMethod XMPBoolean  ContainsPoint(XMPPoint point);
  XMPVMethod XMPBoolean  IsRectangular( );
  
  XMPVMethod XMPRealShape*  Copy( );          // Really returns an XMPPolygonShape*

  XMPVMethod XMPRealShape*  Transform(XMPTransform* transform);
  XMPVMethod XMPRealShape*  Subtract(XMPShape* diffShape);
  XMPVMethod XMPRealShape*  Intersect(XMPShape* sectShape);
  XMPVMethod XMPRealShape*  Union(XMPShape* sectShape);
  
  XMPVMethod XMPRealShape*  Combine( XMPShapeOp, XMPShape* );

  protected:
  XMPVMethod void      InitQDRegion( );
  XMPVMethod gxShape    CopyGXShape( );

  private:
  XMPVMethod XMPRealShape*  Clear( );
      
  XMPPolygon*  fPolygon;
  XMPRect    fBounds;
  XMPBoolean  fBoundsValid;
};


extern char gGX;      // Is GX installed? Initialized by XMPMacShape constructor


#endif //_SHAPEPVM_
