/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    ShapeM.h

  Contains:  Definition of class XMPMacShape

  Written by:  Joshua Susser & Sepp Friedrich & Jens Alfke

*/

#ifndef _SHAPEM_
#define _SHAPEM_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

// JYS: Commented out this mac header file

//#ifndef __FIXMATH__
//#include <FixMath.h>      // Must include before GX headers...
//#endif

// JYS: Commented out mac header 
//#ifndef graphicsTypesIncludes
//#include <graphics types.h>    // Another fine GX header
//#endif


//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPTransform;
class XMPRealShape;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacShape;
class XMPRectShape;

//==============================================================================
// XMPMacShape
//==============================================================================

#define kXMPMacShapeID "appl:xmpmacshape$class,1.0.0"

class XMPMacShape : public XMPAbsShape
{

public:
  //JYS: Move the following code to XMPSess.h
  //static HPS hps;
  //---------------------------------
  // overrides

  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor/destructor

  XMPMacShape();
    // Creates an empty shape.
  
  XMPVMethod ~XMPMacShape();

  XMPVMethod void InitShape( );

  //---------------------------------
  // getters/setters
  
  XMPMethod void SetGeometryMode( XMPGeometryMode mode );
  
  XMPMethod XMPGeometryMode GetGeometryMode( );
  
  XMPMethod void GetBoundingBox( XMPRect *bounds );
  
  XMPMethod XMPShape* SetRectangle( XMPRect *rect );
  
  XMPMethod XMPPolygon* CopyPolygon( );
  
  XMPMethod XMPShape* SetPolygon( XMPPolygon* );

  XMPMethod XMPPlatformShape GetPlatformShape( XMPGraphicsSystem );
  
  XMPMethod void SetPlatformShape( XMPGraphicsSystem, XMPPlatformShape );

  //---------------------------------
  // input / output:
  
  XMPMethod void WriteShape( XMPStorageUnit* );
          
  XMPMethod XMPShape* ReadShape( XMPStorageUnit* );

  //---------------------------------
  // comparison/testing functions

  XMPMethod XMPBoolean IsSameAs(XMPShape* compareShape);

  XMPMethod XMPBoolean IsEmpty( );

  XMPMethod XMPBoolean ContainsPoint(XMPPoint point);
  
  XMPMethod XMPBoolean IsRectangular( );

  XMPMethod XMPBoolean HasGeometry( );

  XMPVMethod void DumpToDebugDisk( const char * prompt );

  //---------------------------------
  // geometry operations

  XMPMethod XMPShape* Copy( );

  XMPMethod void CopyFrom(XMPShape* sourceShape);

  XMPMethod XMPShape* Transform(XMPTransform* transform);

  XMPMethod XMPShape* InverseTransform(XMPTransform* transform);

  XMPMethod XMPShape* Subtract(XMPShape* diffShape);

  XMPMethod XMPShape* Intersect(XMPShape* sectShape);

  XMPMethod XMPShape* Union(XMPShape* sectShape);

  //---------------------------------
  // Mac-specific API extensions
  //JYS: Change function name
  //inline RgnHandle GetQDRegion( )
  inline  RgnHandle GetRegion()
              {return (RgnHandle)this->GetPlatformShape(kXMPOS2PM);}
  //inline void     SetQDRegion( RgnHandle rgn )
  inline void     SetRegion(RgnHandle rgn)
              {this->SetPlatformShape(kXMPOS2PM,(XMPPlatformShape)rgn);}
              // This consumes the region!!
  /*
  inline gxShape   GetGXShape( )
              {return (gxShape)this->GetPlatformShape(kXMPOS2PM);}
  inline void     SetGXShape( gxShape s )
              {this->SetPlatformShape(kXMPOS2PM,(XMPPlatformShape)s);}
  */
 // XMPMethod RgnHandle CopyQDRegion( );
 XMPMethod RgnHandle CopyRegion(); 
//private-by-convention:

  inline XMPRealShape* GetRealShape( )
              {return fShape;}
        
private:

  XMPRealShape*  fShape;
  XMPGeometryMode  fMode;
//JYS: This is a temp solution
//  static HDC  hdc;    
//  static LONG refCnt;
};

#endif // _SHAPEM_