/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SemtIntf.h

   Contains:   SemanticInterface class

   Written by: Nick Pilch

*/

#ifndef _SEMTINTF_
#define _SEMTINTF_


#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _EXTENSN_
#include "Extensn.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsSemanticInterface;
class XMPAEHashTable;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;
class XMPExtension;
class XMPMessageInterface;

//==============================================================================
// Constants
//==============================================================================

enum
{
   cPart = 0x70617274 // 'part'

   // for part info dialog properties
   ,kXMPPCategory = 0x63617465 // 'cate'
   ,kXMPPSize = 0x73697A65 // 'size'
   ,kXMPPCreationDate = 0x63726474 // 'crdt'
   ,kXMPPModDate = 0x6D6F6474 // 'modt'
   ,kXMPPAuthor = 0x61757468 // 'auth'
   ,kXMPPIcon = 0x69636F6E // 'icon'
   ,kXMPPName = 0x706E616D // 'pnam'
   ,kXMPPKind = 0x706B6E64 // 'pknd'
   ,kXMPPEditor = 0x65647472 // 'edtr'
   ,kXMPPComments = 0x636D6E74 // 'cmnt'
   ,kXMPPView = 0x76696577 // 'view'
   ,kXMPPIsFrozen = 0x66727A6E // 'frzn'
   //,kXMPPIsStationery = pIsStationeryPad
};

#ifdef __MWERKS__
   // $$$$$ CodeWarrior a1 generates global storage for the const declaration,
   // so #define it instead.
   #define kXMPAppShell ((XMPPart*)0)
#else
   XMPPart* const kXMPAppShell = 0;
#endif

struct OSLContext;
typedef OSLContext XMPOSLContext;
const XMPSize  kOSLContextSize = sizeof(XMPOSLContext*);

//==============================================================================
// Types
//==============================================================================

struct XMPOSLToken
{
public:                    // $$$$$ The 'public:' works around a CodeWarrior a1 bug
   DescType GetDescType() const {return descriptorType;}
   Handle      GetDataHandle() const {return dataHandle;}
   void     SetDescType(DescType type) {descriptorType = type;}
   void     SetDataHandle(Handle hand) {dataHandle = hand;}
   DescType descriptorType;
   Handle      dataHandle;
};

typedef XMPError (*XMPEventHandlerProcPtr)(XMPPart*      thePart,
                                 AppleEvent* theAppleEvent,
                                 AppleEvent* reply,
                                 XMPSLong handlerRefcon);

typedef XMPError (*XMPCoercionHandler)();

typedef XMPError (*XMPDescCoercionHandler)(XMPPart*      thePart,
                                 AEDesc*     theAEDesc,
                                 DescType toType,
                                 XMPSLong handlerRefCon,
                                 AEDesc*     result);

typedef XMPError (*XMPPtrCoercionHandler)(XMPPart*    thePart,
                                 DescType typeCode,
                                 XMPPtr      dataPtr,
                                 XMPSize     dataSize,
                                 DescType toType,
                                 XMPSLong handlerRefCon,
                                 AEDesc*     result);

typedef XMPError (*XMPAccessorProcPtr)(XMPPart*          thePart,
                              DescType       desiredClass,
                              XMPOSLToken*      container,
                              DescType       containerClass,
                              DescType       form,
                              AEDesc*           selectionData,
                              XMPOSLToken*      value,
                              XMPSLong       handlerRefCon);

typedef XMPError (*XMPCompareProcPtr)(XMPPart*           thePart,
                              DescType       oper,
                              XMPOSLToken*      obj1,
                              XMPOSLToken*      obj2,
                              XMPBoolean*       result,
                              XMPSLong       refCon);

typedef XMPError (*XMPCountProcPtr)(XMPPart*       thePart,
                           DescType       desiredType,
                           DescType       containerClass,
                           XMPOSLToken*      container,
                           XMPSLong*         result,
                           XMPSLong       refCon);

typedef XMPError (*XMPDisposeTokenProcPtr)(XMPPart*         thePart,
                                 XMPOSLToken*   unneededToken,
                                 XMPSLong    refCon);

typedef XMPError (*XMPGetErrDescProcPtr)(XMPPart*     thePart,
                                 AEDesc** errDesc,
                                 XMPSLong refCon);

typedef XMPError (*XMPGetMarkTokenProcPtr)(XMPPart*            thePart,
                                 XMPOSLToken*      dContainerToken,
                                 DescType       containerClass,
                                 XMPOSLToken*      result,
                                 XMPSLong       refCon);

typedef XMPError (*XMPMarkProcPtr)(XMPPart*           thePart,
                           XMPOSLToken*      dToken,
                           XMPOSLToken*      markToken,
                           XMPSLong       index,
                           XMPSLong       refCon);

typedef XMPError (*XMPAdjustMarksProcPtr)(XMPPart*          thePart,
                                 XMPSLong       newStart,
                                 XMPSLong       newStop,
                                 XMPOSLToken*      markToken,
                                 XMPSLong       refCon);

typedef XMPError (*XMPSpecialHandlerPtr)();

typedef XMPPart* (*XMPTokenInquiryProcPtr)(XMPOSLToken*  token,
                                 XMPSLong    refCon);

//==============================================================================
// XMPSemanticInterface
//==============================================================================

class XMPAbsSemanticInterface : public XMPExtension
{
  public:

   XMPAbsSemanticInterface() {}
   XMPVMethod ~XMPAbsSemanticInterface() {}

   //--------------------------------------------------------------------------
   // Extension Interface
   //--------------------------------------------------------------------------

   XMPVMethod void Release()
      =0;

   //--------------------------------------------------------------------------
   // Content Model
   //--------------------------------------------------------------------------

   XMPVMethod void      InstallObjectAccessor(DescType            desiredClass,
                                    DescType       containerType,
                                    XMPAccessorProcPtr   theAccessor,
                                    XMPSLong       accessorRefcon)
      = 0;

   XMPVMethod void      GetObjectAccessor(DescType          desiredClass,
                                 DescType          containerType,
                                 XMPAccessorProcPtr*  theAccessor,      // return parameter
                                 XMPSLong*         accessorRefcon)      // return parameter
      = 0;  

   XMPVMethod void      RemoveObjectAccessor(DescType          desiredClass,
                                   DescType           containerType,
                                   XMPAccessorProcPtr theAccessor)
      = 0;

   XMPVMethod void InstallCompareProc(XMPCompareProcPtr  compareProc,
                                 XMPSLong    refCon)
      = 0;

   XMPVMethod void InstallCountProc(XMPCountProcPtr   countProc,
                                 XMPSLong refCon)
      = 0;

   XMPVMethod void InstallDisposeTokenProc(XMPDisposeTokenProcPtr disposeTokenProc,
                                 XMPSLong             refCon)
      = 0;

   XMPVMethod void InstallGetMarkTokenProc(XMPGetMarkTokenProcPtr getMarkTokenProc,
                                    XMPSLong          refCon)
      = 0;

   XMPVMethod void InstallMarkProc(XMPMarkProcPtr  markProc,
                                 XMPSLong refCon)
      = 0;

   XMPVMethod void InstallAdjustMarksProc(XMPAdjustMarksProcPtr   adjustMarksProc,
                                 XMPSLong          refCon)
      = 0;

   XMPVMethod void InstallGetErrDescProc(XMPGetErrDescProcPtr  errorDescProc,
                                 XMPSLong       refCon)
      = 0;

   XMPVMethod void InstallTokenInquiryProc(XMPTokenInquiryProcPtr tokenInquiryProc,
                                    XMPSLong       refCon)
      = 0;

   //--------------------------------------------------------------------------
   // Semantic Events
   //--------------------------------------------------------------------------

   XMPVMethod void   InstallEventHandler(AEEventClass          theAEEventClass,
                                 AEEventID            theAEEventID,
                                 XMPEventHandlerProcPtr  handler,
                                 XMPSLong             handlerRefcon)
      = 0;
   
   XMPVMethod void   RemoveEventHandler(AEEventClass              theAEEventClass,
                                AEEventID             theAEEventID,
                                XMPEventHandlerProcPtr   handler)
      = 0;
   
   XMPVMethod void   GetEventHandler(AEEventClass           theAEEventClass,
                              AEEventID            theAEEventID,
                              XMPEventHandlerProcPtr* handler,
                              XMPSLong*            handlerRefcon)
      = 0;
   
   XMPVMethod void   InstallCoercionHandler(DescType              fromType,
                                   DescType           toType,
                                   XMPCoercionHandler handler,
                                   XMPSLong           handlerRefcon,
                                   XMPBoolean         fromTypeIsDesc)
      = 0;
   
   XMPVMethod void   RemoveCoercionHandler(DescType            fromType,
                                  DescType         toType,
                                  XMPCoercionHandler  handler)
      = 0;
   
   XMPVMethod void   GetCoercionHandler(DescType               fromType,
                                   DescType           toType,
                                   XMPCoercionHandler*   handler,
                                   XMPSLong*          handlerRefcon,
                                   XMPBoolean*        fromTypeIsDesc)
      = 0;
   
   XMPVMethod void   InstallSpecialHandler(AEKeyword              functionClass,
                                    XMPSpecialHandlerPtr handler,
                                    XMPSLong          refCon)
      = 0;
   
   XMPVMethod void   RemoveSpecialHandler(AEKeyword               functionClass,
                                    XMPSpecialHandlerPtr handler)
      = 0;
   
   XMPVMethod void   GetSpecialHandler(AEKeyword               functionClass,
                                 XMPSpecialHandlerPtr*   handler,
                                 XMPSLong*            refCon)
      = 0;

   XMPVMethod void      SetOSLSupportFlags(short flags)
      = 0;

   XMPVMethod short  GetOSLSupportFlags()
      = 0;
};


#ifdef PLATFORM_MACINTOSH
#ifndef _SEMTINTM_
#include "SemtIntM.h"
#endif
#endif

#endif // _SEMTINTF_
