/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    RefCtObj.h

   Contains:   Class definition for XMPRefCntObject

   Written by: Vincent Lo

*/

#ifndef _REFCTOBJ_
#define _REFCTOBJ_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file defines class XMPRefCntObject.  This class is the common base class
   for all XMP classes whose objects require ref counting.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPRefCntObject;

//==============================================================================
// XMPObject
//==============================================================================

#define kXMPRefCntObjectID "appl:refcntobject$class,1.0.0"

class XMPRefCntObject : public XMPObject
{

public:

   XMPRefCntObject();
   
   virtual ~XMPRefCntObject();
   
   XMPNVMethod void  InitRefCntObject();
   
   //-------------------------------------------------------------------------
   // From ObjectStorage protocol
   //-------------------------------------------------------------------------

   XMPVMethod  void  IncrementRefCount();
   
      // Increments the ref count for the object.
   
   XMPVMethod  void  Release();
   
      // Decrements the ref count for the object.
      
   XMPVMethod  XMPULong GetRefCount();
      
protected:

   XMPULong fRefCount;
      
      
};

#endif // _REFCTOBJ_
