/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    QDFix.h

   Contains:   Fix for QuickDraw.h   [Mac Only]

   Written by: Jens Alfke, Tantek elik

   Theory of Operation:

   We've had a lot of trouble with QuickDraw.h defining an enum constant called "frame" whose
   value is zero. If a function uses a local variable "frame" but forgets to define it, the
   global frame is used instead. Since it's zero, which can be cast implicitly to NULL, this
   usually results in a null pointer being used instead of an XMPFrame, leading to obscure
   crashes later on. We have spent literally days tracking down problems stemming from this.
   To fix this, we employ some sleight-of-hand to prevent QuickDraw.h from defining that
   constant by renaming it "kQDFrameVerb". This way the compiler will properly generate a
   syntax error if some schmuck forgets to declare a local "frame" variable.
   
   This header must be included before <QuickDraw.h>. This header is included by PlfmType.h.
*/


#ifndef __QDFIX__
#define __QDFIX__

#ifdef __QUICKDRAW__
   #error "Yo! Please include QDFix.h before QuickDraw.h!"
#else
   #define frame kQDFrameVerb    // Use this instead of "frame" in QD grafProcs.
   #define APPLEINCL_QuickDraw
   #ifndef APPLEINCLUDED
      #include <Apple.h>
   #endif
   #undef frame
#endif

#endif
