/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    PstObj.h

   Contains:   Class definition for XMPPersistentObject

   Written by: Vincent Lo


*/

#ifndef _PSTOBJ_
#define _PSTOBJ_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file defines class XMPPersistentObject.  This class is the common base
   class for all XMP classes whose objects require persistent storage.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPPersistentObject;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPStorageUnit;

//==============================================================================
// XMPObject
//==============================================================================

#define kXMPPersistentObjectID "appl:persistentobject$class,1.0.0"

class XMPPersistentObject : public XMPRefCntObject
{
public:

   XMPPersistentObject();
   
   virtual ~XMPPersistentObject();
   
   XMPNVMethod void  InitPersistentObject(XMPStorageUnit* storageUnit);
   XMPNVMethod void  InitPersistentObjectFromStorage(XMPStorageUnit* storageUnit);
      
   XMPVMethod  void  ReleaseAll();
   
   XMPVMethod  void  Externalize();
                           
   XMPVMethod  XMPStorageUnit* GetStorageUnit();
   
      // Returns the storage unit of this object.
   
   XMPVMethod  XMPID    GetID();
   
      // Returns the ID of the object.
      
private:

   XMPStorageUnit*   fSU;
   XMPID       fID;
};

#endif // _PSTOBJ_
