/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    PrtPrpAc.h

  Contains:  Interface to class that handles accessing part properties for
        the OpenDoc shell.

  Written by:  Nick Pilch

*/

#ifndef _PRTPRPAC_
#define _PRTPRPAC_

//#ifndef _DRAWPART_
//#include "DrawPart.h"
//#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _PROPACSR_
#include "PropAcsr.h"
#endif

 #define APPLEINCL_AppleEvents
 #ifndef APPLEINCLUDED
    #include <Apple.h>
 #endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
  This a simple abstract class to aid in the processing of Apple Events that
  are requests to get or set properties. Since OpenDoc does the resolution
  first, the object accessor routines can allocate one of these classes
  according to the property for which they have been asked to create a token.
  When passed back to the event handler, the event handler need only call the
  the appropriate member function of this class, GetData or SetData, to
  process the event. The event handler must then delete the object.
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class DrawPartPropAccessor;
class EmbeddedPartPropAccessor;
class DragPartPropAccessor;

//==============================================================================
// Classes used by this interface
//==============================================================================

class DrawPart;
class DragPart;

//==============================================================================
// PropAccessor
//==============================================================================

class AbsDrawPartPropAccessor : public PropAccessor
{
  public:

  AbsDrawPartPropAccessor(DescType property, XMPObject* object);
  XMPVMethod void SetData(AppleEvent* message);
  XMPVMethod void GetData(AppleEvent* reply);

//  XMPVMethod DescType GetProperty();

  protected:
  XMPObject*  fObject;
  DescType  fProperty;
};

#if 0
   class DrawPartPropAccessor : public AbsDrawPartPropAccessor
   {
     public:
   
     DrawPartPropAccessor(DescType property, DrawPart* part);
   
     XMPVMethod void SetData(AppleEvent* message);
     
     XMPVMethod void GetData(AppleEvent* reply);
   
   #ifdef TO_BE_DELETED
     private:
   
     DescType  fProperty;
     DrawPart*  fPart;
   #endif // TO_BE_DELETED
   };
   
   class EmbeddedPartPropAccessor : public AbsDrawPartPropAccessor
   {
     public:
   
     EmbeddedPartPropAccessor(DescType property, DrawPart* part);
   
     XMPVMethod void SetData(AppleEvent* message);
     
     XMPVMethod void GetData(AppleEvent* reply);
   
   #ifdef TO_BE_DELETED
     private:
   
     DescType  fProperty;
     DrawPart*  fPart;
   #endif // TO_BE_DELETED
   };
#endif

class FramePropAccessor : public AbsDrawPartPropAccessor
{
  public:

  FramePropAccessor(DescType property, XMPFrame* frame);

  XMPVMethod void SetData(AppleEvent* message);
  XMPVMethod void GetData(AppleEvent* reply);

#ifdef TO_BE_DELETED
  private:

  DescType  fProperty;
  XMPFrame*  fFrame;
#endif // TO_BE_DELETED
};

class DragPartPropAccessor : public PropAccessor
{
  public:

  DragPartPropAccessor(DescType property, DragPart* part);

  XMPVMethod void SetData(AppleEvent* message);
  
  XMPVMethod void GetData(AppleEvent* reply);

  private:

  DescType  fProperty;
  DragPart*  fPart;
};

#endif // _PRTPRPAC_