/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    PlfmType.h

  Contains:  Platform-specific Types

  Written by:  Vincent Lo

*/

#ifndef _PLFMTYPE_
#define _PLFMTYPE_

#include <stdlib.h>
#ifndef OS2DEF_INCLUDED
#define INCL_GPI
#include <os2.h>
#endif

// JPA: Moved QD fix to QDFix.h to allow precompilation of Toolbox headers w/o PlfmType.h.

#ifndef __QDFIX__    //feb
#include "QDFix.h"   //feb
#endif               //feb

#ifndef _PLFMDEF_    //feb
#include "PlfmDef.h" //feb
#endif               //feb

#ifndef __MEMORY__
#include <Memory.h>
#endif

#define APPLEINCL_Types
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#define APPLEINCL_LibraryManager
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef __FILES__
#include <Files.h>
#endif

#ifdef __WINDOWS__
#include <Windows.h>
#endif

#ifndef __MENUS__
#include <Menus.h>
#endif

#define APPLEINCL_Events
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif


#define APPLEINCL_AERegistry
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifdef __LIBRARYMANAGERUTILITIES__
//#include <LibraryManagerUtilities.h>
#endif

#ifndef __LOWMEM__   //feb
#include <LowMem.h>  //feb     // New replacement for SysEqu.h
#endif               //feb

#include <stdlib.h>  //feb     // For size_t type

#define XMPDebug 0   //dferror - can't find, so I'm turning it off for now

//==============================================================================
// Classes used by this interface
//==============================================================================
#include <os2.h>
#include "os2def.h"
//#include "pmgpi.h"
#ifndef __IMAGSTUB
#include "imagstub.h"
#endif
class XMPPart;

//==============================================================================
// Scalar Types
//==============================================================================

typedef  Boolean      XMPBoolean;    // boolean value. Do not count on its size.
typedef unsigned char  XMPUByte;    // unsigned >= 8-bit value
typedef char      XMPSByte;    // signed >= 8-bit value
typedef unsigned short  XMPUShort;    // unsigned >= 16-bit value
typedef short      XMPSShort;    // signed >= 16-bit value
typedef unsigned long  XMPULong;    // unsigned >= 32-bit value
typedef signed long    XMPSLong;    // signed >= 32-bit value
typedef  float      XMPFloat;    // Single precision (32-bit) floating point  //feb
typedef double      XMPDouble;    // Double-precision (64-bit) floating point    //feb

//error with extended type dferror
//typedef extended    XMPExtended;  // Extended-precision (80 or 96-bit) FP        //feb
typedef  Fixed      XMPFixed;    // fixed-point (16.16) value                 //feb

typedef void*      XMPPtr;      // XMP pointer
typedef XMPUByte*    XMPRawPtr;    // generic pointer


// KS Stuff
struct FSSpec
{
  unsigned long vRefNum;
  unsigned long parID;
  char name[256];
};


typedef unsigned long AEKeyword;

typedef  XMPULong THz;
typedef  XMPULong ProcessSerialNumber;

typedef  XMPULong OSType;


typedef unsigned long AEEventID;
struct OSLContext;
typedef void* CallbackCallerProc;
typedef char Str63[64];
typedef char Str255[256];

#define pascal
#define fsFromStart SEEK_SET
#define fsFromLEOF  SEEK_END
#define fsAtMark    SEEK_CUR
#define fsRdWrPerm  1

#define TRY    try{
//#define THROW(error)  throw( CatchError(error));  //dferror YJ says works without??
#define CATCH(error)  }catch(CatchError){
#define CATCH_ALL     }catch(...){
#define RERAISE       throw
#define ENDTRY }

#define Volatile(x)
// KLS: 02/14/94:   #define Debugger(x)

// End of KS Stuff


// OS specific types
//
//  The following typedefs are OS specific. They are put together in this file for the
//  time being. However, they can be put into separate files if desired. For example,
//  all the primitive types will be put in XMPPlatformMisc.h;
//  all graphics system types will be put in XMPPlatformGraphics.h;
//  all File system types will be put in XMPPlatformFiles.h; and so on.
//  The advantage of splitting them in separate files is the changing one type will not
//  require recompiling all the files which includea XMPTypes.h. Also, there may be a lot
//  of OS-specific types. If that's the case, we don't want them all in one file.
//

// Graphics system

typedef Region       XMPRegion;
typedef RgnPtr      XMPRgnPtr;
typedef RgnHandle    XMPRgnHandle;
//typedef  void*      XMPPlatformShape;   // Graphics-system-dependent shape data
//JYS: define XMPPlatformShape as HRGN , instead of void*
typedef  RgnHandle      XMPPlatformShape;   // Graphics-system-dependent shape data


typedef XMPFixed    XMPCoordinate;      // Graphics coordinates; 16.16 fixed by default //feb

//JYS: commented out XMPMatrix def.  XMPMatrix is now defined in matrix.h under \imaging.
//typedef struct { XMPFixed m[3][3]; } XMPMatrix;    // Transform matrix for translation, scaling,
                          // skewing, rotation or any combination.
                          // Same as "mapping" in QuickDraw GX.
//typedef void*        XMPPlatformTransform;  // Graphics-system-dependent transform data
//JYS: Define XMPPlatformTransform as PMATRIXLF
typedef PMATRIXLF       XMPPlatformTransform;  // Graphics-system-dependent transform data


typedef  XMPSShort      XMPGraphicsSystem;    // Type of graphics system
const  XMPGraphicsSystem  kXMPQuickDraw  = 1;  // Macintosh QuickDraw graphics system
const  XMPGraphicsSystem  kXMPQuickDrawGX  = 2;  // Macintosh QuickDraw GX graphics system

//JYS: defined const for OS2PM
const  XMPGraphicsSystem  kXMPOS2PM = 3;  


// dferror - will define these for now because point & rect already defined elsewhere
//#define _POINT_
//#define _RECT_


//feb point and rect ifndef's
// XMPPoint struct. We conditionalize this with a symbol, like the header files, to allow
// alternate definitions to be included first; they can then #define _POINT_ to keep this one
// from being defined here.

#ifndef _POINT_
#define _POINT_

struct XMPPoint {                  // Fixed-point point.
  XMPCoordinate x, y;                // Identical to "gxPoint" in QD GX.
};

#endif //_POINT_

// XMPRect struct. We conditionalize this with a symbol, like the header files, to allow
// alternate definitions to be included first; they can then #define _RECT_ to keep this one
// from being defined here.

#ifndef _RECT_
#define _RECT_

struct XMPRect {
  XMPCoordinate left,  top,            // Identical to "gxRect" in QD GX.
          right, bottom;
};

#endif //_RECT_

// File System

typedef FSSpec      XMPFileSpec;
typedef ScriptCode    XMPScriptCode;
typedef XMPSShort    XMPFileRefNum;  //feb


// Runtime

// typedef THz          XMPHeap;       // from old previous header

typedef Handle      XMPHandle;         //feb

typedef TMemoryPool*    XMPHeap;

typedef ProcessSerialNumber  XMPProcessID;

typedef OSType      XMPOSType;

// Windows

typedef WindowPtr    XMPPlatformWindow;
//JYS: commented out WindowPtr def
//typedef WindowPtr    XMPPlatformCanvas;
typedef GrafPtr     XMPPlatformCanvas;

//JYS: added the following def
typedef double extended;

// Events

typedef XMPUShort     XMPEventType;
typedef EventRecord*   XMPEventData;
typedef XMPULong      XMPIdleFrequency;   //feb
typedef XMPULong      XMPTimerFrequency;   //KLS

// Menus

typedef HWND         XMPPlatformMenu;
typedef XMPSShort    XMPMenuID;
typedef XMPSShort    XMPMenuItemID;
typedef XMPSLong    XMPCommandID;
typedef Handle      XMPPlatformMenuBar;

// Text

//typedef IntlText    XMPIText;
typedef struct                    //feb whole Text - typedef section
{
  ScriptCode  theScriptCode;
  LangCode  theLangCode;
  XMPULong  textLength;
  char    theText[1];
}
XMPIText;

// Semantic Interface

typedef Handle      XMPIcon;
typedef Handle      XMPSound;

typedef AEDesc      XMPObjectSpec;


// Data Translation

typedef XMPOSType  XMPPlatformType;    // Host platform file & data type
/*
typedef struct
{
  char  privates[76];
  long  randSeed;
  BitMap  screenBits;
  Cursor  arrow;
  Pattern  dkGray;
  Pattern  ltGray;
  Pattern  gray;
  Pattern  black;
  Pattern  white;
  GrafPtr  thePort;
}
XMPQDGlobalRec;

*/

// Name Binding

typedef char* XMPEditor;    // An opaque type identifying a specific part editor  //mar
typedef char* XMPContainerSuite;  // An opaque type identifying a specific container suite //feb //mar


// Data Interchange

typedef XMPULong XMPChangeID;      // Content change IDs  /feb


//==============================================================================
// Constants
//==============================================================================

#define kXMPNULL NULL

const  XMPBoolean  kXMPFalse = 0;
const  XMPBoolean  kXMPTrue = 1;

const  XMPMenuID  kXMPAppleMenuID  = 128;
const  XMPMenuID  kXMPFileMenuID  = 129;
const  XMPMenuID  kXMPEditMenuID  = 130;      //feb
const  XMPMenuID  kXMPOCEFileMenuID  = 193;  //feb

//Commented out in our last build
//const  XMPOSType  kXMPDASMenuRsrc  = 0x44525652; // 'DRVR';  //feb

const  XMPChangeID  kXMPUnknownChange = 0;    //feb


#ifndef PLATFORM_OS2
#define nullEvent     0
#define mouseDown  1
#define mouseUp     2
#define keyDown     3
#define keyUp        4
#define autoKey      5
#define updateEvt    6
#define diskEvt       7
#define activateEvt   8
#define osEvt         9

enum {
  kXMPEvtNull     = nullEvent
   ,kXMPEvtMouseDown  = mouseDown
   ,kXMPEvtMouseUp    = mouseUp
   ,kXMPEvtKeyDown    = keyDown
   ,kXMPEvtKeyUp    = keyUp
   ,kXMPEvtAutoKey    = autoKey
   ,kXMPEvtUpdate    = updateEvt
   ,kXMPEvtDisk    = diskEvt
   ,kXMPEvtActivate  = activateEvt
   ,kXMPEvtOS      = osEvt
#endif

enum {
  kXMPEvtNull     = 0
   ,kXMPEvtMouseDown  
   ,kXMPEvtMouseUp    
   ,kXMPEvtMouseMove
   ,kXMPEvtKeyDown    
   ,kXMPEvtKeyUp    
   ,kXMPEvtAutoKey  
   ,kXMPEvtUpdate   
   ,kXMPEvtActivate
   ,kXMPEvtTimer

// SHOULD THESE BE OFFICIAL TOOLBOX-DEFINED CONSTANTS?

  ,kXMPEvtMenu           = 98
  ,kXMPEvtMouseDownEmbedded = 99    // A mouse-down in an embedded frame, or the active border
                    // Sent to the container
  ,kXMPEvtMouseUpEmbedded   = 100    // A mouse-up in an embedded frame, or the active border
                    // Sent to the container
  ,kXMPEvtMouseDownBorder    = 101    // A mouse-down in an embedded frame, or the active border
                    // Sent to the container
  ,kXMPEvtMouseUpBorder     = 102    // A mouse-up in an embedded frame, or the active border
                    // Sent to the container
  ,kXMPEvtWindow         = 103     // Used to offer events in title bar to root part
                    // message contains partCode
};

#define inDesk 0
#define inMenuBar  1
#define inSysWindow 2
#define inContent  3
#define inDrag   4
#define inGrow  5
#define inGoAway 6
#define inZoomIn 7
#define inZoomOut 8

enum {
  kXMPMDInDesk    = inDesk
  ,kXMPMDInMenuBar  = inMenuBar
  ,kXMPMDInSysWindow  = inSysWindow
  ,kXMPMDInContent  = inContent
  ,kXMPMDInDrag    = inDrag
  ,kXMPMDInGrow    = inGrow
  ,kXMPMDInGoAway    = inGoAway
  ,kXMPMDInZoomIn    = inZoomIn
  ,kXMPMDInZoomOut  = inZoomOut
};

void* operator new(size_t size, int* heap);


//feb
#define XMPASLMQDGlobals ( *(XMPQDGlobalRec*)( *(char**)LMGetCurrentA5() \
              - sizeof(XMPQDGlobalRec) + sizeof(GrafPtr) ) )

#define ODVersionString "1.0.0a1"  //feb

// KS Stuff
typedef XMPSByte* Ptr;

class CatchError
{
  int error;
  public:
  CatchError( int error) { this-> error = error; }
  operator int() { return this-> error; }
};

// inline void DebugStr(char *string) {}

#define GetIndString getindstring

inline void getindstring( char* msg, short maxError, short errNum)
{
  msg = "";
}

inline void Fail( unsigned long error, const char *msg = 0)
{
   throw( CatchError(error));
}

inline void FailNULL( void* ptr, unsigned long error)
{
}
inline Ptr NewPtr( unsigned long size)
{
  return new char[size];
}

inline void DisposPtr( Ptr ptr)
{
  delete ptr;
}

inline void* BlockMove( void* target, void* source, unsigned long size)
{
  return memmove( target, source, size);
}

inline unsigned long GetHandleSize( Handle hData)
{
  return *((unsigned long*)hData);
}
inline unsigned long MemError()
{
  return 0;
}
inline Handle   NewHandle( unsigned long size)
{
  unsigned long* pSize;

  char *handle = new char[size+sizeof(unsigned long)];

  pSize = (unsigned long*)handle;
  *pSize = size;

  return (Handle)handle;
}
inline SetHandleSize( Handle hData, unsigned long size)
{
  char *handle;
  unsigned long* pSize;

  pSize = (unsigned long*)hData;

  if ( *pSize )
  {
    delete (char*)hData;
  }

  handle = new char[size+sizeof(unsigned long)];

  pSize = (unsigned long*)handle;
  *pSize = size;

  hData = (Handle)handle;
}
inline void     DisposHandle( Handle hData)
{
  unsigned long* pSize;

  pSize = (unsigned long*)hData;

  if ( *pSize )
  {
    delete (char*)hData;
  }


}

inline WindowPtr FrontWindow()
{
  return NULL;
}


#endif  // _PLFMTYPE_
