/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    PasclStr.h

  Contains:  Pascal string manipulation routines

  Written by:  Nick Pilch

*/

#ifndef _PASCLSTR_
#define _PASCLSTR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifdef THINK_CPLUS
  #ifndef __pascal__
  #include <pascal.h>
  #endif
#else // THINK_CPLUS
  #ifndef __STRINGS__
  #include <strings.h>
  #endif
#endif // THINK_CPLUS

#define APPLEINCL_Types
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

// These routines convert the string in place.

inline StringPtr CToPascalString(char* string)
{
  return c2pstr(string);
}

inline char* PascalToCString(StringPtr string)
{
  return p2cstr(string);
}

void ConcatPascalStrings(Str255 destString, ConstStr255Param srcString);
  // Error checking is done to ensure that the limit of 256 chars is not
  //  exceeded.

void CopyPascalString(Str255 destString, ConstStr255Param srcString);

XMPBoolean EqualPascalStrings(ConstStr255Param str1, ConstStr255Param str2);
  // Returns kXMPTrue if strings are equal, kXMPFalse otherwise. Does a CASE-
  //  INSENSITIVE compare!

void CopyISOStr2PStr(Str255 destString, const XMPISOStr srcString);

StringPtr IntlToPStr(XMPIText* intlText, StringPtr pstr);
  // Caller must allocate storage for pstr. No error checking is done for
  //  strings longer than 255 chars. Simply grabs the text from the theText
  //  field of XMPIText.

void PStrToIntl(StringPtr pstr, XMPIText** intlText);
  // Caller must dispose storage for intlText when done with it. The XMPIText
  //  is created with theScriptCode = smScriptRoman and
  //  theLangCode = langEnglish.

#endif // _PASCLSTR_