/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NmSpcMgr.h

   Contains:   Definition of XMPNameSpaceManager class

   Written by: Caia Grisar

*/

#ifndef _NMSPCMGR_
#define _NMSPCMGR_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _NAMSPACE_
#include "NamSpace.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsNameSpaceManager;

//==============================================================================
// XMPAbsNameSpaceManager
//==============================================================================

class XMPAbsNameSpaceManager : public XMPObject
{
  public:

   XMPAbsNameSpaceManager() {}
   XMPVMethod ~XMPAbsNameSpaceManager() {}
   
   XMPVMethod XMPNameSpace*   CreateNameSpace(XMPISOStr     spaceName,
                                 XMPNameSpace*  inheritsFrom,
                                 XMPULong    numExpectedEntries)
      = 0;
      // Create a new namespace.
      // kXMPErrKeyAlreadyExists is thrown if a namespace with this name
      // already exists. If an out of memory condition is detected, the
      // XMPNameSpace object being constructed will be destroyed and the
      // out of memory exception will be rethrown.
      //  spaceName - the name for this space.
      //  contentType - the type of values that can be registered here:
      //                XMPISOStr or XMPOSType or XMPSLong.
      //  inheritsFrom - XMPNameSpace to search if GetValue fails in this
      //                one.
      //                If NULL, none has been provided. If an
      //                XMPNameSpace is deleted via DeleteNameSpace,
      //                any other XMPNameSpaces using that XMPNameSpace
      //                for inheritence will
      //                remove their references to it.
      //  numExpectedEntries - the number of entries that you expect to make
      //                   in this table.

   XMPVMethod void            DeleteNameSpace(XMPNameSpace* theNameSpace)
      = 0;

      // Remove a namespace.

   XMPVMethod XMPNameSpace*      HasNameSpace(XMPISOStr spaceName)
      = 0;

      // Answer whether there is a NameSpace of this name. NULL is returned
      // if no XMPAbsNameSpace with that name exists, a valid XMPAbsNameSpace*
      // is returned otherwise.
      
   XMPVMethod XMPSize         Purge(XMPSize howMuch)
      = 0;
};

#ifndef _NMSPCMGM_
#include "NmSpcMgM.h"
#endif


#endif // _NMSPCMGR_
