/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NmSpcMgM.h

   Contains:   Definition of XMPMacNameSpaceManager class

   Written by: Caia Grisar

*/

#ifndef _NMSPCMGM_
#define _NMSPCMGM_

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacNameSpaceManager;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPMacNameSpace;
class XMPStringHashTable;
class XMPBaseSession;

//==============================================================================
// XMPMacNameSpaceManager
//==============================================================================

#define kXMPMacNameSpaceManagerID "appl:xmpmacnamespacemanager$class,1.0.0"

class XMPMacNameSpaceManager : public XMPAbsNameSpaceManager
{
  public:

   XMPMacNameSpaceManager();
   XMPNVMethod void InitNameSpaceManager(XMPBaseSession* session, XMPHeap heap);
   XMPVMethod ~XMPMacNameSpaceManager();
   
   XMPVMethod XMPNameSpace*   CreateNameSpace(XMPISOStr     spaceName,
                                    XMPNameSpace*  inheritsFrom,
                                    XMPULong    numExpectedEntries);

   XMPVMethod void            DeleteNameSpace(XMPNameSpace* theNameSpace);

   XMPVMethod XMPNameSpace*   HasNameSpace(XMPISOStr spaceName);

   XMPVMethod XMPSize         Purge(XMPSize howMuch);
   
 private:

   XMPStringHashTable*  fNameSpaceTable;
   XMPBaseSession*      fSession;
   XMPHeap           fHeap;
};

#endif // _NMSPCMGM_
