/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NmSpcItM.h

   Contains:   Definition of XMPMacValueIterator class

   Written by: Caia Grisar

*/

#ifndef _NMSPCITM_
#define _NMSPCITM_

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacValueIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPMacNameSpace;

//==============================================================================
// XMPMacValueIterator
//==============================================================================

#define kXMPMacValueIteratorID "appl:xmpmacvalueiterator$class,1.0.0"

class XMPMacValueIterator : public XMPAbsValueIterator
{
  public:

   XMPMacValueIterator(XMPNameSpace* nameSpace);
   virtual ~XMPMacValueIterator();

   XMPVMethod void         First(XMPISOStr* key, XMPPtr* value, XMPULong* valueLength);
// XMPMethod void       First(XMPOSType* key, XMPPtr* value);
// XMPMethod void       First(XMPSLong* key, XMPPtr* value);
   XMPVMethod void         Next(XMPISOStr* key, XMPPtr* value, XMPULong* valueLength);
// XMPMethod void       Next(XMPOSType* key, XMPPtr* value);
// XMPMethod void       Next(XMPSLong* key, XMPPtr* value);
   XMPVMethod XMPBoolean   IsNotComplete();

  private:
   XMPNVMethod void        FirstNextAux(XMPISOStr* key);
   XMPNVMethod void        FirstNextAux(XMPOSType* key);
   XMPNVMethod void        FirstNextAux(XMPSLong* key);
   void              FirstAux(XMPULong* key, XMPPtr* value);
   void              NextAux(XMPULong* key, XMPPtr* value);

   XMPNameSpace*           fNameSpace;
   XMPNSTypeSpec           fType;
   XMPStringHashTableIterator*   fStrHashIterator;
   XMPAEHashTableIterator*    fAEHashTableIterator;
};

#endif // _NMSPCITM_
