/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NamSpace.h

   Contains:   XMPAbsNameSpace class definition.

   Written by: Nick Pilch

*/

#ifndef _NAMSPACE_
#define _NAMSPACE_


#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file contains an interface for creating name spaces and registering
   symbols within those spaces.
*/

//==============================================================================
// Scalar Types
//==============================================================================

enum XMPNSTypeSpec
{
   kXMPNSTypeISOStr,
   kXMPNSTypeOSType,
   kXMPNSTypeSLong
};

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsNameSpace;
class XMPNameSpace;
class XMPStorageUnitView;


//==============================================================================
// XMPAbsNameSpace
//==============================================================================

class XMPAbsNameSpace : public XMPObject
{
  public:

   XMPVMethod XMPISOStr GetName()
      = 0;

      // Don't modify the return value. Copy instead if you need to modify.

   // kXMPErrWrongType is throw for any of the following nine functions if the
   // the parameter type does not match the type that the XMPAbsNameSpace was
   // initialized with.

   XMPVMethod void      Register(XMPISOStr key, XMPPtr value, XMPULong valueLength)
      = 0;
// XMPVMethod void      Register(XMPOSType key, XMPPtr value)
//    = 0;
// XMPVMethod void      Register(XMPSLong key, XMPPtr value)
//    = 0;

      // register value under key

   XMPVMethod void      Unregister(XMPISOStr key)
      = 0;
// XMPVMethod void      Unregister(XMPOSType key)
//    = 0;
// XMPVMethod void      Unregister(XMPSLong key)
//    = 0;

      // unregister value registered under key

   XMPVMethod XMPBoolean   GetValue(XMPISOStr key, XMPPtr* value, XMPULong* valLen)
      = 0;
// XMPVMethod XMPBoolean   GetValue(XMPOSType key , XMPPtr* value)
//    = 0;
// XMPVMethod XMPBoolean   GetValue(XMPSLong key , XMPPtr* value)
//    = 0;

      // find value registered under key. kXMPErrKeyDoesNotExist is thrown if
      // key was never registered.

   XMPVMethod XMPBoolean   Exists(XMPISOStr key)
      = 0;
// XMPVMethod XMPBoolean   Exists(XMPOSType key)
//    = 0;
// XMPVMethod XMPBoolean   Exists(XMPSLong key)
//    = 0;

      // check for existance of value registered under key. 

   XMPVMethod void         WriteToFile(XMPFileRefNum file)
      = 0;

   XMPVMethod void         ReadFromFile(XMPFileRefNum file)
      = 0;

   XMPVMethod void         WriteToStorage(XMPStorageUnitView* view)
      = 0;

   XMPVMethod void         ReadFromStorage(XMPStorageUnitView* view)
      = 0;

   XMPVMethod XMPSize      Purge(XMPSize size)
      = 0;

  public: // private by convention

   XMPAbsNameSpace() {}
   XMPVMethod ~XMPAbsNameSpace() {}
};

#ifndef _NAMSPACM_
#include "NamSpacM.h"
#endif

#endif // _NAMSPACE_
