/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NamRslvM.h

   Contains:   XMPMacNameResolver class.

   Written by: Caia Grisar

*/

#ifndef _NAMRSLVM_
#define _NAMRSLVM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacNameResolver;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;
class OrderedCollection;
class XMPMessageInterface;
class XMPSession;
class XMPContext;
class XMPFrame;
class XMPSemanticInterface;
class XMPAEHashTable;

//==============================================================================
// Structures used by this interface
//==============================================================================

struct OSLContext;

//==============================================================================
// XMPMacNameResolver
//==============================================================================

#define kXMPMacNameResolverID "appl:xmpmacnameresolver$class,1.0.0"

class XMPMacNameResolver : public XMPAbsNameResolver
{
  public:

   XMPVMethod void         Resolve(XMPObjectSpec*        theObject, 
                           XMPOSLToken*   token,
                           XMPPart*    contextPart);

   XMPVMethod void         CreateSwapToken(XMPOSLToken*  token,
                                       XMPFrame*   frame);

   XMPVMethod void         CreateToken(XMPOSLToken*      token,
                              DescType       type,
                              XMPPart*       inPart);

   XMPVMethod XMPFrame* GetContainingFrame();

   XMPVMethod void      GetContextInfo(XMPFrame** frame, XMPPart** part);

   XMPVMethod void            CallObjectAccessor(
                                    XMPPart*       thePart,
                                    DescType    desiredClass,
                                    XMPOSLToken*   containerToken,
                                    DescType    containerClass,
                                    DescType    keyForm,
                                    AEDesc*        keyData,
                                    XMPOSLToken*   token);

   XMPVMethod void         DisposeToken(XMPOSLToken* theToken);

   XMPVMethod XMPSize      Purge(XMPSize howMuch);

  public: // private by convention

   XMPMacNameResolver();
   XMPVMethod ~XMPMacNameResolver();
   XMPNVMethod void InitNameResolver(XMPSession* session);
   
   XMPSemanticInterface*   GetSemtIntf(XMPPart* part);
   XMPPart*          GetPartFromToken(XMPOSLToken* token);
   XMPPart*          GetCurrentContextPart();
   void              SetCurrentContextPart(XMPPart*);
   void              SetLastContainer(DescType container)
                           {fLastContainer = container;}
   void              SetLastObject(DescType object)
                           {fLastObject = object;}
   DescType          GetLastContainer() {return fLastContainer;}
   DescType          GetLastObject() {return fLastObject;}
   void              ClearLastSwapFrame() ;

  private:

   OSLContext*    GetContextForPart(XMPPart* part);
   OSLContext*    CreateContext(XMPPart* part);
   void        GetContextFromAnyTokenInList(XMPOSLToken*    token,
                                       OSLContext**   context);
   void        CreateTokenCommon(XMPOSLToken*   token,
                                       XMPPart* part);

   OSLContext*       fRootContext;
// OrderedCollection*   fPartContexts;
   XMPBoolean        fCurrentlyResolving;
   XMPPart*       fCurrentContextPart;
   XMPSession*       fSession;
   XMPAEHashTable*      fContextTable;
   XMPFrame*         fLastSwapFrame;
   DescType       fLastContainer;
   DescType       fLastObject;
};

#endif // _NAMRSLVM_
