/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    MenuBarM.h

   Contains:   Interface to XMPMacMenuBar class.

   Written by: Richard Rodseth

*/

// MenuBarM.h

#ifndef _MENUBARM_
#define _MENUBARM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPMenuBar;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPSession;
class XMPPart;
class OrderedCollection;
class CommandTable;

//=====================================================================================
// Class XMPMacMenuBar
//=====================================================================================

#define kXMPMacMenuBarID "appl:xmpmacmenubar$class,1.0.0"

class XMPMacMenuBar : public XMPAbsMenuBar
{
public:

   XMPMacMenuBar();
   
   virtual ~XMPMacMenuBar();
   
   XMPNVMethod void InitMenuBar(XMPSession* session, XMPPlatformMenuBar menuBar);

   XMPMethod void Release();

   XMPMethod XMPSize Purge(XMPSize size);
   
   XMPMethod void Display();
   
   XMPMethod void AddMenuLast(XMPMenuID menuID, XMPPlatformMenu menu, XMPPart* part);

   XMPMethod void AddMenuBefore(XMPMenuID menuID, XMPPlatformMenu menu, XMPPart* part, XMPMenuID beforeID);

   XMPMethod void AddSubMenu(XMPMenuID menuID, XMPPlatformMenu menu, XMPPart* part);
      
   XMPMethod void RemoveMenu(XMPMenuID menu);   

   XMPMethod XMPPlatformMenu GetMenu(XMPMenuID menu); 

   XMPMethod XMPMenuBar* Copy(); 

public: // Macintosh-specific

   XMPMethod void RegisterCommand(XMPCommandID command,
                           XMPMenuID menu,
                           XMPMenuItemID menuItem);
                           
   XMPMethod void UnregisterCommand(XMPCommandID command);
   
   XMPMethod void UnregisterAll();  
   
   XMPMethod XMPBoolean IsCommandRegistered(XMPCommandID command);

   XMPMethod XMPBoolean IsCommandSynthetic(XMPCommandID command);    
   
   XMPMethod XMPCommandID GetCommand(XMPMenuID menu,
                           XMPMenuItemID menuItem);
                           
   XMPMethod void GetMenuAndItem(XMPCommandID command,
                           XMPMenuID& menu,
                           XMPMenuItemID& menuItem);
      
   XMPMethod void EnableCommand(XMPCommandID cmdNumber, XMPBoolean enable);

   XMPMethod void CheckCommand(XMPCommandID cmdNumber, XMPBoolean check);

   XMPMethod void EnableAndCheckCommand(XMPCommandID cmdNumber, XMPBoolean enable, XMPBoolean check) ;

   XMPMethod void SetItemString(XMPCommandID cmdNumber, ConstStr255Param itemString);

   XMPMethod void GetItemString(XMPCommandID cmdNumber, Str255 itemString);

protected:
   
   XMPSession* fSession;

    XMPPlatformMenuBar fSystemMenus;
    OrderedCollection* fOtherMenus; 
    
    CommandTable* fCommandTable; // a mapping from (menu/item) to command number  
};

#endif // _MENUBARM_
