/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*--------------------------------------------------------------------
 *   JYS: March 14, 1994   Initial Creation
 *   Class definition for Matrix
 *-------------------------------------------------------------------*/ 
#ifndef __MATRIX_H
#define __MATRIX_H

#define INCL_GPITRANSFORMS
//#define INCL_PRIMITIVES
#include <os2def.h>
#include <os2.h>

#ifndef _ALTPOINT_
#include "altpoint.h"
#endif

#include <stdio.h>

struct XMPMatrix 
{ 
       XMPFixed m[3][3]; 
}; 

class XMPOS2Matrix : public MATRIXLF
{
public:
   XMPOS2Matrix();                 //Constructor
   XMPOS2Matrix( XMPOS2Matrix &m);    
   XMPOS2Matrix( XMPMatrix &x);     
   void ResetMapping();
   BOOL InvertMapping(XMPOS2Matrix *m);
   BOOL IsSameAs(XMPOS2Matrix *m);
   void MoveMapping(int dx, int dy);
   void MapPoints( int num, POINTL *p);
   void MapPoints( int num, XMPPoint *p);
   void MapMapping(XMPOS2Matrix *m1, XMPOS2Matrix *m2);
   void CopyToMapping(XMPOS2Matrix *m);
   void print(); //print out matrix
   inline LONG det();

private:
   void Calc(XMPOS2Matrix *result, XMPOS2Matrix *m1, XMPOS2Matrix *m2);
   inline FIXED calc(FIXED a1, FIXED a2, LONG a3, FIXED b1, FIXED b2, LONG b3);
};

inline FIXED XMPOS2Matrix::calc(FIXED a1, FIXED a2, LONG a3, FIXED b1, FIXED b2, FIXED b3)
{
   return (FIXED) (a1*b1 + a2*b2 + a3*b3);
}

inline LONG XMPOS2Matrix::det()
{
  return (fxM11 * fxM22 * lM33  ) + (fxM21 * lM32  * lM13  ) + (lM31  * lM23  * fxM12 ) -
         (lM13  * fxM22 * lM31  ) - (lM23  * lM32  * fxM11 ) - (lM33  * fxM21 * fxM12 ) ;
}
#endif
