/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    LksrIter.h

  Contains:  Class definition of XMPLinkSourceIterator.

  Written by:  Craig Carper

*/

#ifndef _LKSRITER_
#define _LKSRITER_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef __CM_API_TYPE_
#include "CMAPITyp.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPLinkSourceIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================
class XMPDraft;
class XMPLinkSource;

//==============================================================================
// LinkIterator
//==============================================================================

#define kXMPLinkSourceIteratorID "appl:xmplinksourceiterator$class,1.0.0"

class XMPLinkSourceIterator {

public:

  XMPLinkSourceIterator();
  virtual  ~XMPLinkSourceIterator();
  XMPMethod  void  InitLinkSourceIterator(XMPDraft* draft);
  
  XMPMethod  XMPLinkSource*    First();
  
  XMPMethod  XMPLinkSource*    Next();
  
  XMPMethod  XMPBoolean     IsNotComplete();
  
private:

  XMPDraft*    fDraft;
  XMPLinkSource*  fLinkSource;
  CMObject    fCurrent;
  CMContainer    fContainer;
  CMProperty    fProperty;
  CMType      fType;
  XMPULong    fSize;
  XMPPtr      fBuffer;
};

#endif  // _LKSRITER_
