/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    LinkSpeM.h

   Contains:   Class definition for XMPMacLinkSpec.

   Written by: Craig Carper 

*/

#ifndef _LINKSPEM_
#define _LINKSPEM_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef __PROCESSES__
#include "Processes.h"
#endif

#define APPLEINCL_Processes
#ifndef APPLEINCLUDED
   #include <Apple.h>
#endif

#ifndef __APPLEEVENTS__
#include "AppleEvents.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This file describes the Macintosh version of link specs.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacLinkSpec;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPStorageUnit;
class XMPDraft;
class XMPPart;

//==============================================================================
// XMPMacLinkSpec
//==============================================================================

#define kXMPMacLinkSpecID "appl:xmpmaclinkspec$class,1.0.0"

class XMPMacLinkSpec : public XMPAbsLinkSpec
{
public:

   // ----------------------------------------
   // Parts may call

   XMPMacLinkSpec();
   
   virtual ~XMPMacLinkSpec();
   
   XMPVMethod void WriteToProperty(XMPStorageUnit* su);

      // Write this object into the pre-focused storage unit.
      // The argument storage unit must be pre-focused to a property.
   
   XMPVMethod void ReadFromProperty(XMPStorageUnit* su);
   
      // Initialize this object from the value in the pre-focused storage unit.
      // The argument storage unit must be pre-focused to a property containing
      // a link spec value.

   // ----------------------------------------
   // Private by convention

   XMPNVMethod void InitLinkSpec(
         XMPPart* part,
         XMPPtr      data,
         XMPULong size);
   
   XMPVMethod ProcessSerialNumber GetProcessID();

      // Returns the process serial number of the originating part

   XMPVMethod XMPULong GetProcessLaunchDate();

      // Returns the launch date of the originating process

   XMPVMethod XMPPart* GetPart();

      // Returns the originating part
      
   XMPVMethod XMPULong  GetDataSize();

      // Returns the size of the link spec data

   XMPVMethod XMPPtr GetDataPtr();

      // Returns a pointer to the link spec data

   XMPVMethod void WriteToAppleEvent(AppleEvent* theAppleEvent);
   
      // Write this object into the argument apple event.

   XMPVMethod void ReadFromAppleEvent(const AppleEvent* theAppleEvent);
   
      // Initialize this object from the argument apple event.

private:

   void VoidLinkSpec();

   // identification of the process creating this link spec
   // unique during a single boot of the local machine
   ProcessSerialNumber fProcessID;
   XMPULong fProcessLaunchDate;     // for validation of fProcessID

   // identification of the source part - only valid during the current session!
   XMPPart* fPart;   // Session-wide identification for the source part

   // Private data for eventual use by the source part
   XMPULong fDataSize;
   XMPPtr fData;
};

#endif
