/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    LinkIter.h


*/

#ifndef _LINKITER_
#define _LINKITER_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef __CM_API_TYPE_
#include "CMAPITYP.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPLinkIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================
class XMPDraft;
class XMPLink;

//==============================================================================
// LinkIterator
//==============================================================================

#define kXMPLinkIteratorID "appl:xmplinkiterator$class,1.0.0"

class XMPLinkIterator {

public:

  XMPLinkIterator();
  virtual  ~XMPLinkIterator();
  XMPMethod  void  InitLinkIterator(XMPDraft* draft);
  
  XMPMethod  XMPLink*    First();
  
  XMPMethod  XMPLink*    Next();
  
  XMPMethod  XMPBoolean     IsNotComplete();
  
private:

  XMPDraft*    fDraft;
  XMPLink*    fLink;
  CMObject    fCurrent;
  CMContainer    fContainer;
  CMProperty    fProperty;
  CMType      fType;
  XMPULong    fSize;
  XMPPtr      fBuffer;
};

#endif  // _LINKITER_
