/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
#ifndef _ISHELL_
#define _ISHELL_

#include <iframe.hpp>
#include <iexcbase.hpp>
#include <ihandler.hpp>
#include <icanvas.hpp>

#ifndef _SHELLM_
#include "shellm.h"
#endif

typedef IEvent IWindowEvent;

class IWindowHandler : public IHandler
{
public:
   Boolean dispatchHandlerEvent(IEvent &);
};

class IShellWindow : public IFrameWindow
{
public:
   IShellWindow(const char *title, 
                IResourceId id,
                XMPShell *shell);
};

class IClient : public ICanvas, public IWindowHandler 
{
public:
   /* -------------------------------------------------------- */
   /* declare the constructor                                  */
   /* -------------------------------------------------------- */
   IClient(IFrameWindow *frame,
           XMPShell *shell );

   Boolean windowEvent(IWindowEvent& evt);

protected:       

   XMPShell *theShell;

}; 
#endif
