/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    Info.h

   Contains:   function declarations for Part Frame Info dialog and getsetters

   Written by: Tantek elik

*/


#ifndef _INFO_
#define _INFO_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================

// ViewAs ISOStr constants

const XMPType  kXMPViewAsSmallIcon     = "OpenDoc:ViewAs:SmallIcon";
const XMPType  kXMPViewAsLargeIcon     = "OpenDoc:ViewAs:LargeIcon";
const XMPType  kXMPViewAsThumbnail     = "OpenDoc:ViewAs:Thumbnail";
const XMPType  kXMPViewAsFrame         = "OpenDoc:ViewAs:Frame";


//==============================================================================
// Scalar Types
//==============================================================================

typedef XMPHandle XMPIconFamily;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPFrame;
class XMPStorageUnit;
class XMPCategorySet;
class XMPPart;
class XMPPersistentObject;

//==============================================================================
// Info functions
//==============================================================================

//-------------------------------------------------------------------------------------
// Part & Frame Info Dialog
//-------------------------------------------------------------------------------------
// public

void  ShowPartFrameInfo(XMPFrame* frame);

//-------------------------------------------------------------------------------------
// Part & Frame Property getters and setters
// Note: 
//  all Getters expect you to pass in a buffer to be filled along 
// with the maxsize if the value being gotten is of variable size
// the actual size is returned in maxsize as well
//  all Setters do NOT consume what you pass in, so it is safe to pass in
// a reference to your internal structures.  They are only accessed for the duration
// of the Setter API call.
// These conventions were adopted to reduce memory allocation/deallocation.
//-------------------------------------------------------------------------------------
// private by convention

void  XMPGetPOName(XMPPersistentObject* pstobj,XMPName* name,XMPULong* maxsize);
void  XMPSetPOName(XMPPersistentObject* pstobj,XMPName* name);

void  XMPGetPOComments(XMPPersistentObject* pstobj,XMPIText* comments,XMPULong* maxsize);
void  XMPSetPOComments(XMPPersistentObject* pstobj,XMPIText* comments);

XMPULong XMPGetPOSize(XMPPersistentObject* pstobj);
XMPULong XMPGetPOCreationDate(XMPPersistentObject* pstobj);
XMPULong XMPGetPOModificationDate(XMPPersistentObject* pstobj);
void     XMPGetPOModifiedBy(XMPPersistentObject* pstobj,Str32 user);

//-------------------------------------------------------------------------------------
// Part only Property getters and setters
//-------------------------------------------------------------------------------------
// private by convention
void  XMPGetCategories(XMPPart* part,XMPCategorySet* comments,XMPULong* maxsize);

XMPType  XMPGetKind(XMPPart* part);

void  XMPGetIconFamily(XMPPart* part,XMPIconFamily iconFamily);
void  XMPSetIconFamily(XMPPart* part,XMPIconFamily iconFamily);

XMPBoolean  XMPGetIsStationery(XMPPart* part);
void     XMPSetIsStationery(XMPPart* part,XMPBoolean isStationery);

//-------------------------------------------------------------------------------------
// Frame only Property getters and setters
//-------------------------------------------------------------------------------------
// see Frame.h

#endif // _INFO_

