/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    FocusSet.h

   Contains:   Interface to XMPFocusSet class

   Written by: Richard Rodseth

*/

#ifndef _FOCUSSET_
#define _FOCUSSET_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPFocusSet;            

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFocusSetIterator;
class LinkedList;

//=====================================================================================
// XMPFocusSet
//=====================================================================================

#define kXMPFocusSetID "appl:xmpfocusset$class,1.0.0"

class XMPFocusSet
{
  public:

   XMPFocusSet();
      
   virtual ~XMPFocusSet();
   
   XMPNVMethod void InitFocusSet();
   
   XMPMethod void Add(XMPTypeToken focus);
   
   XMPMethod void Remove(XMPTypeToken focus);

   XMPMethod XMPBoolean Contains(XMPTypeToken focus);
   
   XMPMethod XMPFocusSetIterator* CreateIterator();
   
  public: // to XMPFocusSetIterator only

   LinkedList* GetImplementation();

  private:
   
   LinkedList* fImplementation;
};

#endif // _FOCUSSET_
