/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    FocusOwn.h

   Contains:   Interface to XMPFocusOwnerIterator class

   Written by: Richard Rodseth

*/

#ifndef _FOCUSOWN_
#define _FOCUSOWN_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPFocusOwnerIterator;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFocusModule;
class XMPFrame;

//=====================================================================================
// Class XMPFocusOwnerIterator
//=====================================================================================

class XMPFocusOwnerIterator
{
public:

   XMPFocusOwnerIterator();
   
   ~XMPFocusOwnerIterator();
   
   XMPNVMethod void InitFocusOwnerIterator(XMPTypeToken focus, XMPFocusModule* module);
   
   XMPVMethod XMPFrame* First() 
      = 0;
      
   XMPVMethod XMPFrame* Next() 
      = 0;
      
   XMPVMethod XMPBoolean IsNotComplete() 
      = 0;
      
protected:

   XMPTypeToken fFocus; 
   XMPFocusModule* fFocusModule;
};

#endif // _FOCUSOWN_
