/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    FocusItr.h

   Contains:   Interface to XMPFocusSetIterator class.

   Written by: Richard Rodseth

*/

#ifndef _FOCUSITR_
#define _FOCUSITR_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPFocusSetIterator;    // Iterator over the elements in a focus set

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFocusSet;            
class LinkedListIterator;

//=====================================================================================
// Class XMPFocusSetIterator
//=====================================================================================

#define kXMPFocusSetIteratorID "appl:xmpfocussetiterator$class,1.0.0"

class XMPFocusSetIterator
{
public:
   
   virtual ~XMPFocusSetIterator();

   XMPMethod XMPTypeToken First();
   
   XMPMethod XMPTypeToken Next();
   
   XMPMethod XMPBoolean IsNotComplete();

public: // Private to UI subsystem

   XMPFocusSetIterator();
   
   XMPNVMethod void InitFocusSetIterator(XMPFocusSet* focusSet);
   
private:
   
   LinkedListIterator* fIterator;
};

#endif // _FOCUSITR_
