/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    FacetNod.h

  Contains:  Definition of class FacetNode

  Written by:  Joshua Susser

*/

#ifndef _FACETNOD_
#define _FACETNOD_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _NODE_
#include "Node.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*

FacetNode-s stitch Facet-s together into a tree structure.  Each Facet has a 
FacetNode which holds its place in the visible frame structure for the document.

*/

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class FacetNode;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class Node;
class XMPFacet;

//=====================================================================================
// FacetNode
//=====================================================================================

class FacetNode : public Node
{

public:
  
  FacetNode(XMPFacet* facet);
    
    // Constructor
  
  XMPVMethod ~FacetNode();
  
    // Destructor

  XMPVMethod XMPFacet*  GetFacet();

private:

  XMPFacet*  fFacet;
};

#endif // _FACETNOD_