/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    Extensn.h

   Contains:   Interface to XMPExtension class

   Written by: Nick Pilch

*/

#ifndef _EXTENSN_
#define _EXTENSN_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   XMPExtension is the abstract base class from which object extension interfaces
   are derived.  The base class itself has minimal behavior.  It knows which
   object it is an extension of, and how to release resources in itself and in
   its object.  Further behavior should be implemented in derived classes.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPExtension;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPObject;

//==============================================================================
// XMPExtension
//==============================================================================

#define kXMPExtensionID "appl:extension$class,1.0.0"

class XMPExtension
{
  public:

   //-------------------------------------------------------------------------
   // From Extensions protocol
   //-------------------------------------------------------------------------

   XMPVMethod XMPObject*   GetBase();  
      
   XMPVMethod void         Release()
      = 0;
      
  protected:

   XMPExtension();
   XMPNVMethod void InitExtension(XMPObject* base);
   virtual ~XMPExtension();

  private:

   XMPObject* fBase;
};


#endif // _EXTENSN_
