/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    ExptDefs.h

   Contains:   Exception strings for Class identification

   Written by: Steve Smith

---------------------------------------------------------------------------

   This is a proposal for creating exception values that can be traced, thus
   making debugging easier. The basic XMPError type is unchanged; however it
   would be transformed into a bit field structure. The Hi-Order byte would
   contain the ID of the Class (as defined below); the Hi-Word Lo-Order byte
   would contain the Method ID (as defined in each .h file); and the Lo-Word
   would contain the Exception code as before. This will also give us the
   ability to log exceptions thrown throughout program execution.
   
   Exception: CCMM EEEE (CC = Class ID, MM = Method ID, EEEE = Exception code)
   
    Example:
    
      ThrowIfError(kXMPFocusSetEID & kAddEID & kXMPErrOutOfMemory);
      
      Actual Exception Value : $0F010015
   
      ((Exception & 0xFF000000) >> 24) = 15 = kXMPFocusSetEID
      ((Exception & 0x00FF0000) >> 16) = 01 = Add
       (Exception & 0x0000FFFF)        = 21 = kXMPErrInvalidToken
      
---------------------------------------------------------------------------*/

// Class Exception IDs

#define kXMPAEHashTableEID                (1 << 24)
#define kXMPAEHashTableIteratorEID        ((kXMPAEHashTableEID + 2) << 24)
#define kXMPArbitratorEID              ((kXMPAEHashTableEID + 3) << 24)
#define kXMPBentoContainerEID          ((kXMPAEHashTableEID + 4) << 24)
#define kXMPContainerEID               ((kXMPAEHashTableEID + 5) << 24)
#define kXMPDocumentEID                ((kXMPAEHashTableEID + 6) << 24)
#define kXMPDraftEID                ((kXMPAEHashTableEID + 7) << 24)
#define kXMPEmbeddedContainerEID       ((kXMPAEHashTableEID + 8) << 24)
#define kXMPEmbeddedHandlersEID           ((kXMPAEHashTableEID + 9) << 24)
#define kXMPFileContainerEID           ((kXMPAEHashTableEID + 10) << 24)
#define kXMPFocusModuleEID             ((kXMPAEHashTableEID + 11) << 24)
#define kXMPFocusModuleAssociationEID     ((kXMPAEHashTableEID + 12) << 24)
#define kXMPFocusOwnerIteratorEID         ((kXMPAEHashTableEID + 13) << 24)
#define kXMPFocusSetEID                ((kXMPAEHashTableEID + 14) << 24)
#define kXMPFocusSetIteratorEID           ((kXMPAEHashTableEID + 15) << 24)
#define kXMPFrameEID                ((kXMPAEHashTableEID + 16) << 24)
#define kXMPFSBentoHandlersEID            ((kXMPAEHashTableEID + 17) << 24)
#define kXMPLayoutEID                  ((kXMPAEHashTableEID + 18) << 24)
#define kXMPMacCanvasEID               ((kXMPAEHashTableEID + 19) << 24)
#define kXMPMacClipboardEID               ((kXMPAEHashTableEID + 20) << 24)
#define kXMPMacDispatcherEID           ((kXMPAEHashTableEID + 21) << 24)
#define kXMPMacDragAndDropEID          ((kXMPAEHashTableEID + 22) << 24)
#define kXMPMacLinkEID                 ((kXMPAEHashTableEID + 23) << 24)
#define kXMPMacMessageInterfaceEID        ((kXMPAEHashTableEID + 24) << 24)
#define kXMPMacNameResolverEID            ((kXMPAEHashTableEID + 25) << 24)
#define kXMPMacNameSpaceEID               ((kXMPAEHashTableEID + 26) << 24)
#define kXMPMacShapeEID                ((kXMPAEHashTableEID + 27) << 24)
#define kXMPMacStorageSystemEID           ((kXMPAEHashTableEID + 28) << 24)
#define kXMPMacSymbolsEID              ((kXMPAEHashTableEID + 29) << 24)
#define kXMPMacTransformEID               ((kXMPAEHashTableEID + 30) << 24)
#define kXMPMacTranslationEID          ((kXMPAEHashTableEID + 31) << 24)
#define kXMPMacValueIteratorEID           ((kXMPAEHashTableEID + 32) << 24)
#define kXMPMacWindowEID               ((kXMPAEHashTableEID + 33) << 24)
#define kXMPMacWindowIteratorEID       ((kXMPAEHashTableEID + 34) << 24)
#define kXMPMacWindowStateEID             ((kXMPAEHashTableEID + 35) << 24)
#define kXMPMemBentoHandlersEID           ((kXMPAEHashTableEID + 36) << 24)
#define kXMPMemoryContainerEID            ((kXMPAEHashTableEID + 37) << 24)
#define kXMPPartEID                    ((kXMPAEHashTableEID + 38) << 24)
#define kXMPPersistentObjectEID           ((kXMPAEHashTableEID + 39) << 24)
#define kXMPRefCntObjectEID               ((kXMPAEHashTableEID + 40) << 24)
#define kXMPSessionEID                 ((kXMPAEHashTableEID + 41) << 24)
#define kXMPSETransactionLinkEID       ((kXMPAEHashTableEID + 42) << 24)
#define kXMPSimpleFocusModuleEID       ((kXMPAEHashTableEID + 43) << 24)
#define kXMPStandardDispatchModuleEID     ((kXMPAEHashTableEID + 44) << 24)
#define kXMPStorageUnitEID             ((kXMPAEHashTableEID + 45) << 24)
#define kXMPStorageUnitViewEID            ((kXMPAEHashTableEID + 46) << 24)
#define kXMPStringHashTableEID            ((kXMPAEHashTableEID + 47) << 24)
#define kXMPStringHashTableEID            ((kXMPAEHashTableEID + 48) << 24)
#define kXMPStringHashTableIteratorEID    ((kXMPAEHashTableEID + 49) << 24)
#define kXMPStringHashTableIteratorEID    ((kXMPAEHashTableEID + 50) << 24)
#define kXMPUndoEID                    ((kXMPAEHashTableEID + 51) << 24)
