/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    EmbedCtr.h

  Contains:  Definition of XMPEmbeddedContainer

  Written by:  Vincent Lo

*/

#ifndef _EMBEDCTR_
#define _EMBEDCTR_

#ifndef _XMPCTR_
#include "XMPCtr.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _DOCUMENT_
#include "Document.h"      // included for XMPDocumentID
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_TYPES__
#include "CMAPITyp.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
*/


//==============================================================================
// Classes used by this interface
//==============================================================================
class  XMPStorageSystem; 
class  XMPSCollection;
class  XMPBentoHandlers;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPEmbeddedContainer;

//==============================================================================
// XMPEmbeddedContainer
//==============================================================================

class XMPEmbeddedContainer : public XMPContainer {

public:

  //-------------------------------------------------------------------------
  // From ObjectStorage protocol
  //-------------------------------------------------------------------------

  XMPMethod  XMPStorageSystem* GetStorageSystem();
  
  XMPMethod  XMPContainerID GetID();
  
    // returns ID of this Container

  XMPMethod  XMPContainerName GetName();
  
    // returns name of this Container
      
  XMPMethod  void SetName(XMPContainerName name);

  XMPMethod XMPDocument* GetDocument(XMPDocumentID id);  

  XMPMethod  void  IncrementRefCount();

    // OVERRIDE
    // See base class.
  
  XMPMethod  void  Release();

    // OVERRIDE
    // See base class.


private:

  XMPStorageSystem*      fStorageSystem;
  CMValue            fID;
  XMPBentoHandlers*      fHandlers;
  
  XMPContainerName*      fName;
  XMPSCollection*        fDocuments;
  
  XMPHeap            fHeap;
  CMContainer          fContainer;
    
public:  // private by convention

  XMPEmbeddedContainer();
          
    // Returns an uninitialized XMPEmbeddedContainer object. 
    // Initialize should be called immediately after this function.
    
  virtual ~XMPEmbeddedContainer();
  
    // Closes the container in persistent storage if it is still open.

  XMPNVMethod void InitContainer(XMPStorageSystem* storage,
                    XMPContainerID id);

    // OVERRIDE
    // Called after constructor

  XMPMethod XMPContainer* Create();  
    // Creates a container in persistent storage
      
  XMPMethod XMPContainer* Open();
  
    // Opens container in persistent storage        
  
  XMPMethod XMPContainer* Close();
  
    // Closes container in persistent storage      

  XMPMethod XMPSize Purge(XMPSize size);    
  
    // OVERRIDE
    // Gets rid of any unnecessary memory by purging memory blocks
    //  or flushing structures out to disk

  XMPMethod XMPContainer* ReleaseDocument(XMPDocument* document);  


  XMPMethod  XMPContainer*  Abort();
  CMContainerUseMode      fUseMode;
    
  XMPMethod XMPHeap      GetHeap();
  XMPMethod CMContainer    GetCMContainer();
};


#endif  // _EMBEDCTR_
