/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    DraftWin.h

   Contains:   definition of the DraftWin and DraftInfoRec classes

   Written by: Tantek elik

*/

#ifndef _DRAFTWIN_
#define _DRAFTWIN_

#ifndef _DRAFT_
#include "Draft.h"
#endif

#ifndef __DIALOGS__
#include "Dialogs.h"
#endif

#ifndef __LISTS__
#include "Lists.h"
#endif

//==============================================================================
// Constants
//==============================================================================

#define kXMPDraftWinNone   0
#define kXMPDraftWinOpen   1
#define  kXMPDraftWinDone  2
#define kXMPDraftWinCreate 3
#define  kXMPDraftWinDelete   4
//==============================================================================
// Scalar Types
//==============================================================================

typedef  XMPULong XMPDraftWinAction;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPDraftWindow;   // very platform dependent
class DraftInfoRec;

//==============================================================================
// Classes used by this interface
//==============================================================================

class DraftInfoRec 
{
   DraftInfoRec*  fNext;
   DraftInfoRec*  fFirst;
   XMPDraft*      fDraft;
   XMPStorageUnit*   fDraftProperties;
   XMPDraftID     fDraftID;
   XMPULong    fDraftNumber;
   XMPULong    fCreated;
   XMPIText*      fComment;
   XMPSByte    fModifiedBy[33];
   
public:

   DraftInfoRec();
   XMPNVMethod void  InitDraftInfoRec(XMPDraft* draft);
      // note: draft reference is consumed in Init and released in destructor
   XMPVMethod  ~DraftInfoRec();
   
   XMPMethod   DraftInfoRec*  Next()      { return fNext; }
   XMPMethod   XMPULong    Number() { return fDraftNumber; }
   XMPMethod   XMPDraft*      Draft()     { return fDraft;  }
   XMPMethod   void  GetUserStrings(Str255 aStr255);
   
// only call these on the first DraftInfoRec
   XMPMethod   void  InternalizeHistory();
   XMPMethod   void  VerifyUpdate();

protected:
   XMPMethod   XMPIText*   GetComment();
   XMPMethod   void     SetComment(XMPIText* newComment);

};


//==============================================================================
// XMPDraftWindow
//==============================================================================

class XMPDraftWindow
{  
  public:

   XMPDraftWindow();
   XMPNVMethod void  InitDraftWindow(XMPDraft* draft);
   XMPVMethod     ~XMPDraftWindow();

   XMPMethod   XMPDraftWinAction Drafts(XMPDraft* draft);
   XMPMethod   XMPDraft*         GetSelectedDraft()   {return fSelectedDraft;}
   
   XMPMethod   void  DraftCreated(XMPDraft* draft);   
   // used to init the Draft Properties
   // can be used independently of other methods including initialize

  protected:
   XMPMethod   XMPBoolean  CreateDraft();
   XMPMethod   XMPBoolean  RemoveSelectedDrafts();
   XMPMethod   void  Print();
   
// XMPMethod   void  SelectAllDrafts();

   XMPMethod   void  BuildDraftList(ListHandle listH);
   XMPMethod   ListHandle MakeAList(DialogPtr dlgPtr, XMPSShort itemNum, XMPBoolean scrollH, XMPBoolean scrollV);

  private:
   XMPDraft*         fDraft;
   XMPDocument*      fDocument;
// XMPPlatformWindow fWindow;
   DraftInfoRec*     fDraftInfo;
   XMPDraft*      fSelectedDraft;
   XMPULong    fSelectedDraftNumber;
};



#endif   // _DRAFTWIN_
