/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    DrafPriv.h

*/

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

class XMPAEHashTable;

class IDList {

public:

  IDList();
  XMPVMethod  ~IDList();
  
  XMPMethod void Initialize();
  
  XMPMethod void  Add(XMPID id, void* object);
  XMPMethod XMPID Add(void* object);
  XMPMethod void   Remove(XMPID id);

  XMPMethod void*  Get(XMPID id);
  XMPMethod XMPID  GetID(void* object);
  
  XMPMethod XMPBoolean  Exists(XMPID id);
  XMPMethod XMPBoolean  ObjectExists(void* object);

private:

  XMPHeap      GetHeap();
  
  XMPAEHashTable*  fIDToObj;
  XMPAEHashTable*  fObjToID;
  XMPID      fCurrentID;
  XMPHeap      fHeap;
};
