/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    DispMod.h

   Contains:   Abstract class XMPDispatchModule

   Written by: Richard Rodseth

*/

#ifndef _DISPMOD_
#define _DISPMOD_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPDispatchModule;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPSession;

//=====================================================================================
// XMPDispatchModule
//=====================================================================================

#define kXMPDispatchModuleID "appl:xmpdispatchmodule$class,1.0.0"

class XMPDispatchModule
{
public:
      
   XMPDispatchModule();
   
   virtual ~XMPDispatchModule();
   
   XMPNVMethod void InitDispatchModule(XMPSession* session);
   
#ifdef USE_EVENT_TYPES
   XMPVMethod XMPBoolean Dispatch(XMPEventData event)
      = 0;
#else
   XMPVMethod XMPULong Dispatch(XMPEventData event)
      = 0;
#endif
   
protected:

   XMPSession* fSession; // Access to globals
   XMPBoolean  fInitialized; // Used to catch multiple initializes
   
};

#endif // _DISPMOD_
