/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    DgItmItr.h

   Contains:   Class definition for DragItem.
   
   Written by: Vincent Lo

*/

#ifndef _DGITMITR_
#define _DGITMITR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPDragItemIterator;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPStorageUnit;
class LinkedListIterator;

//=====================================================================================
// XMPDragItemIterator
//=====================================================================================

#define kXMPDragItemIteratorID "appl:xmpdragitemiterator$class,1.0.0"

class XMPDragItemIterator
{
public:

   XMPDragItemIterator(LinkedListIterator* dragItemListIter);
   
   virtual  ~XMPDragItemIterator();
   
   XMPMethod   XMPStorageUnit*   First();
   XMPMethod   XMPStorageUnit*   Next();
   XMPMethod   XMPBoolean     IsNotComplete();
   
private:

   LinkedListIterator *fDragItemListIter;
};

#endif   // _DGITMITR_
