/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    ClipbdM.h

  Contains:  Class definition for XMPMacClipboard.

  Written by:  Vincent Lo

*/

#ifndef _CLIPBDM_
#define _CLIPBDM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPMacClipboard;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPAbsClipboard;
class XMPStorageUnit;
class XMPDraft;
class XMPDocument;
class XMPContainer;
class XMPSession;
class XMPSimpleFocusModule;
class XMPPlatformTypeSet;

//=====================================================================================
// XMPClipboard
//=====================================================================================

#define kXMPMacClipboardID "appl:xmpmacclipboard$class,1.0.0"

class XMPMacClipboard : public XMPAbsClipboard
{
public:
    
  XMPMacClipboard();
  
  XMPVMethod ~XMPMacClipboard();

  XMPNVMethod void InitClipboard(XMPSession* session);
    
  XMPVMethod XMPSize Purge(XMPSize size);

  XMPVMethod XMPBoolean Lock(XMPULong wait, XMPClipboardKey* key);
                              
  XMPVMethod void Unlock(XMPClipboardKey key);

  XMPVMethod XMPChangeID GetChangeID();
                               
  XMPVMethod void Clear(XMPClipboardKey key);
    
  XMPVMethod XMPStorageUnit* GetContentStorageUnit(XMPClipboardKey key);
    
  XMPVMethod void SetPlatformClipboard(
            XMPPlatformTypeSet* typeSet,
            XMPClipboardKey key);

  XMPVMethod void ExportClipboard(XMPClipboardKey key);
    
private:

  XMPMethod void NewClipboard ();
  XMPMethod void DiscardClipboard ();
  XMPMethod void ImportContent();
  XMPMethod void PutContentOnPlatformClipboard();
  XMPMethod void ExportPlatformTypes(XMPPlatformTypeSet* typeSet);
  XMPMethod void PutClipboardOnPlatformClipboard();
  XMPMethod Boolean ImportClipboard();

  XMPSession*        fSession;
  Handle          fContainerHandle;
  XMPContainer*      fContainer;
  XMPDocument*      fDocument;
  XMPDraft*        fDraft;
  XMPStorageUnit*      fSU;
  
  XMPBoolean        fLocked;
  XMPChangeID        fChangeID;
  XMPChangeID        fNextChangeID;

  short          fScrapCount;      // Mac desk scrap counter of last import
  short          fScrapCountLastChange;  // Need to update platform clipboard
};

#endif // _CLIPBDM_