/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    CanvasM.h

  Contains:  Definitions of XMPMacCanvas

  Written by:  Joshua Susser & Sepp Friedrich

*/

#ifndef _CANVASM_
#define _CANVASM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

#ifndef _PLFMTYPE_
#include "PlfmType.h"
#endif

// JYS: commented out this mac header

//#ifndef __FIXMATH__
//#include <FixMath.h>      // Must include before GX headers...
//#endif

// JYS: Commented out Mac header files
//#ifndef graphicsTypesIncludes
//#include <graphics types.h>    // Another fine GX header; needed only for gxViewPort.
//#endif
              
//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPPart;
class XMPFacet;
class XMPShape;

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacCanvas;

//==============================================================================
// XMPMacCanvas
//==============================================================================

#define kXMPMacCanvasID "appl:xmpmaccanvas$class,1.0.0"

class XMPMacCanvas : public XMPAbsCanvas
{

public:

  //---------------------------------
  // overrides

  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor & destructor

  XMPMacCanvas();
        
  XMPVMethod ~XMPMacCanvas();

  XMPNVMethod void InitCanvas(XMPGraphicsSystem graphicsSystem,
          XMPPlatformCanvas  platformCanvas,
          XMPBoolean     isDynamic,
          XMPBoolean     isOffscreen);
        
  //---------------------------------
  // getters

  XMPMethod XMPGraphicsSystem  GetGraphicsSystem();
  
  XMPMethod XMPPlatformCanvas  GetPlatformCanvas();
  //JYS: Add ReleasePlatformCanvas()
  XMPMethod void ReleasePlatformCanvas();

  XMPMethod XMPPart* GetOwner();
  XMPMethod void SetOwner(XMPPart* owner);
  
  XMPMethod XMPFacet* GetFacet();
  XMPMethod void SetFacet(XMPFacet* facet);
  
  XMPMethod XMPBoolean    IsDynamic();
  
  XMPMethod XMPBoolean    IsOffscreen();
    
  //---------------------------------
  // update region

  XMPMethod XMPShape* GetUpdateShape();

  XMPMethod void ResetUpdateShape();

  XMPMethod void Invalidate(XMPShape* shape);

  XMPMethod void Validate(XMPShape* shape);

  XMPMethod void CheckUpdateShape();
   
private:

  XMPPart*      fOwner;
  XMPFacet*      fFacet;
  XMPShape*      fUpdateShape;
  XMPBoolean      fIsDynamic;   
  XMPBoolean      fIsOffscreen;
  XMPGraphicsSystem  fGraphicsSystem;
  XMPBoolean      ShouldRelease;     // New to OS/2: indentify whether we should release cached PS
//JYS: Commented out union
/*
  union{
    XMPPlatformCanvas  fPlatformCanvas;
    GrafPtr        fQDPort;
    gxViewPort      fGXPort;
  };
*/
    XMPPlatformCanvas  fPlatformCanvas; // XMPPlatformCanvas = HPS is OS/2
};

#endif // _CANVASM_