/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Canvas.h

  Contains:  Definitions of class XMPAbsCanvas

  Written by:  Joshua Susser & Sepp Friedrich

*/

#ifndef _CANVAS_
#define _CANVAS_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"      // base class
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsCanvas;

//==============================================================================
// Classes used in this interface
//==============================================================================

class XMPFacet;
class XMPPart;
class XMPShape;

//==============================================================================
// XMPCanvas
//==============================================================================

class XMPAbsCanvas : public XMPObject
{

public:

  //---------------------------------
  // overrides

//  XMPVMethod XMPSize Purge(XMPSize size);    // override from XMPObject

  //---------------------------------
  // constructor & destructor

  XMPAbsCanvas() {};

  XMPVMethod ~XMPAbsCanvas() {};
  
  //---------------------------------
  // getters

  XMPVMethod XMPGraphicsSystem GetGraphicsSystem()
    = 0;
  
  XMPVMethod XMPPlatformCanvas GetPlatformCanvas()
    = 0;
  
  XMPVMethod XMPPart* GetOwner()
    = 0;
  XMPVMethod void SetOwner(XMPPart* owner)
    = 0;

  XMPVMethod XMPFacet* GetFacet()
    = 0;
  XMPVMethod void SetFacet(XMPFacet* facet)
    = 0;

  XMPVMethod XMPBoolean IsDynamic()
    = 0;
  
  XMPVMethod XMPBoolean IsOffscreen()
     = 0;

  //---------------------------------
  // update region

  XMPMethod XMPShape* GetUpdateShape()
     = 0;

  XMPMethod void ResetUpdateShape()
     = 0;

  XMPMethod void Invalidate(XMPShape* shape)
     = 0;

  XMPMethod void Validate(XMPShape* shape)
     = 0;
};

#if PLATFORM_MACINTOSH
#ifndef _CANVASM_
#include "CanvasM.h"
#endif
#endif

#endif // _CANVAS_