/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    FileCtr.h

  Contains:  Definition of XMPBentoContainer

  Written by:  Vincent Lo

*/

#ifndef _BENTOCTR_
#define _BENTOCTR_

#ifndef _XMPCTR_
#include "XMPCtr.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

#ifndef _BENTOHDR_
#include "BentoHdr.h"
#endif

#ifndef _DOCUMENT_
#include "Document.h"      // included for XMPDocumentID
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_TYPES__
#include "CMAPITyp.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
*/

//==============================================================================
// Classes used by this interface
//==============================================================================
class  XMPStorageSystem; 
class  XMPDocument;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPBentoContainer;

//==============================================================================
// XMPBentoContainer
//==============================================================================

class XMPBentoContainer : public XMPContainer {

public:

  //-------------------------------------------------------------------------
  // From ObjectStorage protocol
  //-------------------------------------------------------------------------

  XMPVMethod  XMPStorageSystem* GetStorageSystem();
  
  XMPVMethod  XMPContainerID GetID();
  
    // returns ID of this Container

  XMPVMethod  XMPContainerName GetName();
  
    // returns name of this Container
      
  XMPVMethod  void SetName(XMPContainerName name);

  XMPVMethod XMPDocument* GetDocument(XMPDocumentID id);  

  XMPVMethod  void  IncrementRefCount();

    // OVERRIDE
    // See base class.
  
  XMPVMethod  void  Release();

    // OVERRIDE
    // See base class.
        
protected:
  
  XMPStorageSystem*      fStorageSystem;
  XMPContainerID        fID;
  XMPBentoHandlers*      fHandlers;
  
  XMPContainerName*      fName;
  XMPDocument*        fDocument;

  CMContainer          fCMContainer;
  XMPBoolean          fDirty;
  
  XMPHeap            fHeap;
  
public: // private by convention

  XMPBentoContainer();
          
    // Returns an uninitialized XMPContainer object. 
    // Initialize should be called immediately after this function.
    
  XMPVMethod ~XMPBentoContainer();
  
    // Closes the container in persistent storage if it is still open.

  XMPVMethod void InitContainer(XMPStorageSystem* storage, XMPContainerID id);

    // OVERRIDE
    // Called after constructor

  XMPVMethod XMPContainer* Create()
    = 0;
    
    // Creates a container in persistent storage
      
  XMPVMethod XMPContainer* Open()
    = 0;
  
    // Opens container in persistent storage        
  
  XMPVMethod XMPContainer* Close();
  
    // Closes container in persistent storage      

  XMPVMethod XMPSize Purge(XMPSize size);    
  
    // OVERRIDE
    // Gets rid of any unnecessary memory by purging memory blocks
    //  or flushing structures out to disk

  XMPVMethod XMPContainer* ReleaseDocument(XMPDocument* document);  

  XMPMethod  CMContainer  GetCMContainer();
  XMPMethod  void    SetDirtyFlag();
  XMPMethod  XMPHeap    GetHeap();

};


#endif  // _FILECTR_
