/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    SysSessM.h

   Contains:   XMPMacSystemSession class definition

   Written by: Vincent Lo

*/

#ifndef _BASESESS_
#define _BASESESS_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPBaseSession;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPStorageSystem;
class XMPNameSpaceManager;
class XMPBinding;

//==============================================================================
// XMPBaseSession
//==============================================================================

#define kXMPBaseSessionID "appl:XMPBaseSession$class,1.0.0"

class XMPBaseSession : public XMPObject
{
  public:

   XMPVMethod XMPStorageSystem*     GetStorageSystem();

   XMPVMethod void                  Close();

   XMPVMethod XMPSize               Purge(XMPSize size);

   XMPVMethod XMPNameSpaceManager*     GetNameSpaceManager();

   XMPVMethod XMPBinding*           GetBinding()
      = 0 ;

  public: // Private by convention

   XMPBaseSession();
   XMPNVMethod void  InitSession();
   XMPVMethod ~XMPBaseSession();

  protected:

   XMPStorageSystem*    fStorage;
   XMPNameSpaceManager* fNameSpaceManager;
};


#endif // _BASESESS_
