/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPCtr.h

   Contains:   Definition of XMPContainer

   Written by: Vincent Lo, Tantek I. Celik

*/

#ifndef _XMPCTR_
#define _XMPCTR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

#ifndef _DOCUMENT_
#include "Document.h"
#endif

//==============================================================================
// Constants
//==============================================================================
const XMPDocumentID  kXMPDefaultDocument = 1;

//==============================================================================
// Classes used by this interface
//==============================================================================
class XMPStorageSystem; 
class XMPDocument;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPContainer;

//==============================================================================
// XMPContainer
//==============================================================================

class XMPContainer : public XMPRefCntObject {

public:

   XMPVMethod  XMPStorageSystem* GetStorageSystem()
      = 0;
   
   XMPVMethod  XMPContainerID GetID()
      = 0;
   
   XMPVMethod  XMPContainerName GetName()
      = 0;
            
   XMPVMethod  void SetName(XMPContainerName name)
      = 0;

   XMPVMethod XMPDocument* GetDocument(XMPDocumentID id)
      = 0;

   XMPVMethod  void  IncrementRefCount()
      = 0;

   XMPVMethod  void  Release()
      = 0;
            
public:  // private by convention

   XMPContainer() {}
      
   XMPVMethod ~XMPContainer() {}

   XMPVMethod void InitContainer(XMPStorageSystem* system, XMPContainerID id)
      = 0;

   XMPVMethod XMPContainer* Create()
      = 0;
         
   XMPVMethod XMPContainer* Open()
      = 0;
   
   XMPVMethod XMPContainer* Close()
      = 0;

   XMPVMethod XMPSize Purge(XMPSize size)
      = 0;

   XMPVMethod XMPContainer* ReleaseDocument(XMPDocument* document)
      = 0;
};


#endif   // _XMPCTR_
