/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    DispTabl.h

   Contains:   Definition of class DispatchTable, which is private to the implementation of
            XMPDispatcher.

   Written by: Richard Rodseth

*/

#ifndef _DISPTABL_
#define _DISPTABL_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Theory of Operation
//=====================================================================================

/*
   See Disptch.h

   Contains an array of dispatch modules for the first 256 event codes. If there are 
   any more, they go in an overflow linked list. A Windows implementation might  use 
   a hash table instead, since there are so many more messages.

*/

//=====================================================================================
// Constants
//=====================================================================================

const XMPEventType kXMPLastEvent = 255; //   Index of last entry in the dispatch table

// Exception codes. These will move to XMPError.h

const XMPError kXMPErrDispatchModuleAlreadyExists = 801;
const XMPError kXMPErrDispatcherNotInitialized = 802;

//=====================================================================================
// Scalar Types
//=====================================================================================

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class DispatchTable;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class DispatchInfo;
class OrderedCollection;
class DictionaryList;
class XMPDispatchModule;

//=====================================================================================
// Global Variables
//=====================================================================================

//=====================================================================================
// Class DispatchTable
//=====================================================================================

class DispatchTable
{
public:

   DispatchTable();
   
      // Constructor
      
   ~DispatchTable();
   
      // Destructor

   void AddMonitor(XMPEventType eventType, 
               XMPDispatchModule* dispatchModule);
               
   void RemoveMonitor(XMPEventType eventType,XMPDispatchModule* dispatchModule);
   
   void AddDispatchModule(XMPEventType eventType, 
                     XMPDispatchModule* dispatchModule);
                     
   void RemoveDispatchModule(XMPEventType eventType);
   
   XMPDispatchModule* GetDispatchModule(XMPEventType eventType);

   OrderedCollection* GetMonitors(XMPEventType eventType);
   
protected:

   DispatchInfo* GetDispatchInfo(XMPEventType eventType);
   void UpdateDispatchInfo(XMPEventType eventType, DispatchInfo* info);
   
private:

   DispatchInfo* fDispatchInfo[kXMPLastEvent + 1]; // An array for the first 256 event types
   DictionaryList* fOverflowDispatchInfo;            // A dictionary for those that don't 
                                      // fit in the array
                              
};

#endif // _DISPTABL_
