/* memory.h (emx+gcc) */

#if !defined (_MEMORY_H)
#define _MEMORY_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (_MEMDIF_EQ)
#define _MEMDIF_EQ 0xffffffff
#endif

void *memccpy (void *s1, __const__ void *s2, int c, size_t n);
void *memchr (__const__ void *s, int c, size_t n);
int memcmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memcpy (void *s1, __const__ void *s2, size_t n);
int memicmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memmove (void *s1, __const__ void *s2, size_t n);
void *memset (void *s, int c, size_t n);

size_t _memcount (__const__ void *mem, int c, size_t n);
size_t _memdif (__const__ void *mem1, __const__ void *m2m, size_t n);
void _memswap (void *s1, void *s2, size_t n);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_MEMORY_H) */
