/* io.h (emx+gcc) */

#if !defined (_IO_H)
#define _IO_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (SEEK_SET)
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

struct stat;
struct _fd_set;
struct timeval;

int access (__const__ char *name, int mode);
int chmod (__const__ char *name, int pmode);
int chsize (int handle, long size);
int close (int handle);
int creat (__const__ char *name, int pmode);
int dup (int handle);
int dup2 (int handle1, int handle2);
int eof (int handle);
long filelength (int handle);
int fstat (int handle, struct stat *buffer);
int fsync (int handle);
int ftruncate (int handle, long length);
int ioctl (int handle, int request, ...);
int isatty (int handle);
long lseek (int handle, long offset, int origin);
char *mktemp (char *string);
int open (__const__ char *name, int oflag, ...);
int pipe (int *two_handles);
int read (int handle, void *buf, size_t nbyte);
int remove (__const__ char *name);
int rename (__const__ char *old_name, __const__ char *new_name);
int select (int nfds, struct _fd_set *readfds, struct _fd_set *writefds,
    struct _fd_set *exceptfds, struct timeval *timeout);
int setmode (int handle, int mode);
int sopen (__const__ char *name, int oflag, int shflag, ...);
int stat (__const__ char *name, struct stat *buffer);
long tell (int handle);
int truncate (char *name, long length);
int umask (int pmode);
int unlink (__const__ char *name);
int write (int handle, __const__ void *buf, size_t nbyte);

int _crlf (char *buf, size_t size, size_t *new_size);
int _imphandle (int handle);
int _isterm (int handle);
int _seek_hdr (int handle);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_IO_H) */
