#include <windows.h>
#include "time.h"

HANDLE  hInstance;
FARPROC lpTimerCallback;
BOOL    bCallback;
HWND    hWndMain;
CHAR    szText[80];

int PASCAL WinMain (HANDLE hInst, HANDLE hInstPrev, LPSTR lpstrCmdLine, 
                    int cmdShow)
{
    MSG      msg;
    WNDCLASS wc;

    hInstance = hInst;

    if (hInstPrev == NULL)
    {
        wc.lpszMenuName     = "AppMenu";
        wc.lpszClassName    = "AppClass";
        wc.hInstance        = hInst;
        wc.hIcon            = LoadIcon(hInst, "AppIcon");
        wc.hCursor          = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground    = COLOR_WINDOW + 1;
        wc.style            = 0;
        wc.lpfnWndProc      = MainWndProc;
        wc.cbClsExtra       = 0;
        wc.cbWndExtra       = 0;

        if (!RegisterClass (&wc))
            return (0);
    }

    if ((hWndMain = CreateWindow ("AppClass",
                                  "Application Title",
                                  WS_OVERLAPPEDWINDOW,
                                  CW_USEDEFAULT, 0,
                                  CW_USEDEFAULT, CW_USEDEFAULT,
                                  NULL, NULL, hInst, NULL)) == NULL)
       return(0);

    ShowWindow (hWndMain, cmdShow);
    UpdateWindow (hWndMain);

    while (GetMessage ((LPMSG) &msg, NULL, 0, 0))
    {
       TranslateMessage ((LPMSG) &msg);
       DispatchMessage ((LPMSG) &msg);
    }

    if (TimerType != cmdStop)
        KillTimer (hwndKill, idKill);

    return(0);
}

LONG FAR PASCAL MainWndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
    HMENU hMenu;
    HDC   hdc;
   DWORD dwTime;

    switch (msg) 
   {
        case WM_COMMAND:
            switch (wParam) 
         {
             case IDM_STARTCALLBACK:
                 hMenu = GetMenu (hWnd);
                 EnableMenuItem (hMenu, IDM_STARTCALLBACK, FALSE);
                 EnableMenuItem (hMenu, IDM_START, FALSE);
                 EnableMenuItem (hMenu, IDM_STOP, TRUE);
                 lpTimerCallback = MakeProcInstance (TimerCallbackProc, hInst);
                    SetTimer (NULL, 1, 1000, lpTimerCallback);
                 bCallback = TRUE;
                 break;

             case IDM_START:
                 hMenu = GetMenu (hWnd);
                 EnableMenuItem (hMenu, IDM_STARTCALLBACK, FALSE);
                 EnableMenuItem (hMenu, IDM_START, FALSE);
                 EnableMenuItem (hMenu, IDM_STOP, TRUE);
                    SetTimer (hWnd, 1, 1000, NULL);
                 bCallback = FALSE;
                 break;

             case IDM_STOP:
                 hMenu = GetMenu (hWnd);
                 EnableMenuItem (hMenu, IDM_STARTCALLBACK, TRUE);
                 EnableMenuItem (hMenu, IDM_START, TRUE);
                 EnableMenuItem (hMenu, IDM_STOP, FALSE);
                    KillTimer (hWnd, 1);
                 if (bCallback)
                     FreeProcInstance (lpTimerCallback);
                 break;
            }
            break;

        case WM_TIMER:
            MessageBeep (0);
            hdc = GetDC (hWnd);
            dwTime = GetCurrentTime ();
            wsprintf ((LPSTR)&szText, "WM_TIMER received - %ld", dwTime );
            TextOut (hdc, 10, 10, (LPSTR)&szText, lstrlen ((LPSTR)&szText));
            ReleaseDC (hwnd, hdc);
            break;

        case WM_DESTROY:
            PostQuitMessage(0);
            break;

        default:
            return(DefWindowProc(hwnd, msg, wParam, lParam));
    }

    return(0);
}

WORD FAR PASCAL TimerCallbackProc (HWND hWnd, WORD msg, int idEvent, 
                                   DWORD dwtime)
{
    HDC hdc;

    MessageBeep (0);
    hdc = GetDC (hWndMain);
    dwTime = GetCurrentTime ();
    wsprintf ((LPSTR)&szText, "WM_TIMER callback received - %ld", dwTime );
    TextOut (hdc, 10, 40, (LPSTR)&szText, lstrlen ((LPSTR)&szText));
    ReleaseDC (hWndMain, hdc);

    return (0);
}
