/*************************************************************
LINK.c

**************************************************************/



/********************* GLOBALS *******************************/

CHAR szFileName[CCHMAXPATH];    /* Holds current XR file */
CHAR szXRName[MAXXRNAME+1];     /* Used to return the XR name +1 for NULL */
USHORT usRetXRType;             /* Used to return selected XR Type */
BOOL FILE_ISOPEN = FALSE;       /* File Open flag */
BOOL FILE_CHANGED = FALSE;      /* File Changed flag */
BOOL COMMAND_LINE_FILE = FALSE; /* Flag to determine if a file was on the CL */
HHXRP hhp;                      /* Pointer to the heap */
CHAR *szAscii,*szScratch;       /* 2 Pointer used to return misc. strings */
HOLDFXR *pHoldFXR;              /* Global XR linked-list pointer          */
DELETELIST *pDelList;           /* Global ptr to l-l of deleted XRs       */
XRDATA ConvTable[XRTABLESIZE] = {    /* Setup the table */
   { XR_LPBINARY  ,"Length preceeded hex binary\0        ",IDD_LPDATA},
   { XR_LPASCII   ,"Length preceeded ascii\0             ",IDD_LPDATA},
   { XR_ASCIIZ    ,"Asciiz\0                             ",IDD_ASCIIZ},
   { XR_LPBITMAP  ,"Length preceeded bitmap\0            ",IDD_LPDATA},
   { XR_LPMETAFILE,"Metafile\0                           ",IDD_LPDATA},
   { XR_LPICON    ,"Length preceeded icon\0              ",IDD_LPDATA},
   { XR_ASCIIZFN  ,"Asciiz file name of associated data\0",IDD_ASCIIZ},
   { XR_ASCIIZXR  ,"Asciiz XR of associated data\0       ",IDD_ASCIIZ},
   { XR_MVMT      ,"Multi value multi type field\0       ",IDD_MULTILIST},
   { XR_MVST      ,"Multi value single type field\0      ",IDD_MULTILIST},
   { XR_ASN1      ,"ASN.1 field\0                        ",IDD_ASCIIZ},
   { 0            ,"Non conventional format\0            ",IDD_ASCIIZ}
   };

/*************************************************************/

/*
 * Function name: main()
 *
 *
 */

int main(int argc, char *argv[])
{
   HAB          hab;
   HMQ          hmq;

   if)(argc > 1)  /* If a command line file, get XRs from it */
      if(ParseFileName(szFileName,argv[1]) != FILE_VALID) /* Bad file name */
         *szFileName=0;
      else
         COMMAND_LINE_FILE = TRUE;

   /* Note:  The following 3 setup calls aren't currently checked for errors */
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);
   hhp = WinCreateHeap(0, 0, GROWSIZE, 0, 0,
                          HM_MOVXRBLE | HM_VALIDSIZE | HM_VALIDFLAGS);

   WinDlgBox(HWND_DESKTOP, HWND_DESKTOP,
                         MainDlgProc,NULL,IDD_MAIN,NULL);

   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   return 0;
}
     if (WinDlgBox(HWND_DESKTOP,
             hwndFrame,    /* handle of the owner         */
             OpenDlg,      /* dialog procedure address    */
             NULLHANDLE,   /* location of dialog resource */
             IDD_OPEN,     /* resource identifier         */
             NULL)) {      /* application-specific data   */


/*
 * Function name: MainDlgProc()
 *
 */

MRESULT EXPENTRY MainDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   HPOINTER hpointer;
   USHORT   usRet;

   switch(msg)
   {
      case WM_INITDLG:
         hpointer = WinLoadPointer(HWND_DESKTOP,            /* Set Nead Icon */
                                   (HMODULE) NULL,IDR_XRD);
         WinPostMsg(hwnd,WM_SETICON,hpointer,0L);
                                                       
                                                              
         /* Get XRs from file on Command line, or prompt for file name */
         WinPostMsg(hwnd,WM_USER,NULL,NULL);
         return 0L;

      case WM_USER:  /* Posted by WM_INITDLG allows main window to open 1st */
         OpenFile(hwnd, COMMAND_LINE_FILE ? ARGFILE : NULL);
         return 0L;

      case WM_COMMAND:
         switch(COMMANDMSG(&msg)->cmd)
         {
            case IDD_NEWFILE:     /* Select another file to view/edit XRs */
               OpenFile(hwnd,0);
               return 0L;

            case IDD_ADD:         /* Add an XR to current list in memory  */
               AddXR(hwnd);
               return 0L;

            case IDD_DELETE:      /* Delete an XR from memory             */
               DeleteCurXR(hwnd);
               return 0L;

            case IDD_WRITE:       /* Write XR's out to disk               */
               WriteXRs(hwnd);
               return 0L;

            case IDD_EDIT:        /* Edit the hilited XR                  */
               EditXR(hwnd);
               return 0L;
         
            case IDD_ASM:
                  LinkAsm();
                  return 0;

            case IDD_COPY:        /* Copy and Paste aren't                */
            case IDD_PASTE:       /* currently implemented                */
               return 0L;

            case IDD_QUIT:
               if(FILE_CHANGED)   /* Give user a chance to save changes   */
               {
                  usRet=WinMessageBox(HWND_DESKTOP,hwnd,
                  "The current file has been changed.  Do you"
                  "wish to save the changes before proceeding?",
                  "Warning",NULL,MB_YESNOCANCEL | MB_ICONQUESTION);
                  switch(usRet)
                  {
                     case MBID_YES:    /* They want to save the XRs       */
                        WriteXRs(hwnd);
                        break;
                     case MBID_CANCEL: /* They don't really want to quit  */
                        return 0L;
                  }
               }
               WinDismissDlg(hwnd,TRUE);
               return 0L;
         }

      case WM_CONTROL:
         switch(SHORT1FROMMP(mp1))
         {
            case IDD_LBOX:
               switch(SHORT2FROMMP(mp1))
               {
                  case LN_SELECT:       /* A new item has been hi-lited */
                     ShowXRType(hwnd);  /* Display appropriate XR Type  */
                     return 0L;

                  case LN_ENTER:        /* Edit the selected XR         */
                     EditXR(hwnd);
                     return 0L;
               }
         }
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/*
 * Function name: AddXRProc()
 *
 */

MRESULT EXPENTRY AddXRProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static CHAR bPDat = 0; /* flag indicating if the pPDat struct is valid */
   PASSDATA FAR *pPDat;   /* struct used to pass in default XR name       */

   switch(msg)
   {
      case WM_INITDLG:
         bPDat = 0;
         WinSendDlgItemMsg(hwnd, IDD_XRNAME,EM_SETTEXTLIMIT,
                                 MPFROM2SHORT(MAXXRNAME,0),NULL);
         WinSendDlgItemMsg(hwnd, XR_LPASCII,BM_CLICK,0L,0L);

         pPDat=PVOIDFROMMP(mp2);
         if(pPDat)
         {
            bPDat = 1;
            WinSetDlgItemText(hwnd, IDD_XRNAME,pPDat->Point);
            WinSetDlgItemText(hwnd, IDD_TITLE,
                              "Add a Multi-type field to the XR");
            WinEnableWindow(WinWindowFromID(hwnd,IDD_XRNAME),
                            FALSE);                /* Disable XR Name field */
            WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,DID_OK));

            return TRUE;       /* We don't want default focus setting */
         }
         return 0L;

      case WM_COMMAND:
         switch(COMMANDMSG(&msg)->cmd)
         {
            case DID_OK:
               if(bPDat == 0)          /* It is a new XR (not multi-type)   */
               {
                  WinQueryDlgItemText(hwnd, IDD_XRNAME, MAXXRNAME+1, szXRName);

                  if(!strlen(szXRName))    /* Don't allow a Null XR Name    */
                  {
                     WinAlarm(HWND_DESKTOP,WA_ERROR);
                     WinMessageBox(HWND_DESKTOP, hwnd,
                                   "Cannot create a NULL XR name.",
                                   NULL, 0, MB_OK);
                     return 0L;
                  }

                  if(XRExists(szXRName))   /* Don't allow duplicate XR Name */
                  {
                     WinAlarm(HWND_DESKTOP,WA_ERROR);
                     WinMessageBox(HWND_DESKTOP, hwnd,
                          "XR name already exists.  Can't create that name.",
                          NULL, 0, MB_OK);
                     return 0L;
                  }
               }
               usRetXRType = (USHORT) WinSendDlgItemMsg(hwnd, XR_ASCIIZ,
                                                   BM_QUERYCHECKINDEX, 0L, 0L);
               WinDismissDlg(hwnd, TRUE);
               return 0L;

            case DID_CANCEL:
               WinDismissDlg(hwnd, FALSE);
               return 0L;
         }
         break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/*
 * Function name: AddXRProc()
 *

 */


MRESULT EXPENTRY AsciiEditProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static PASSDATA FAR *pPDat;

   switch(msg)
   {
      case WM_INITDLG:
         WinSendDlgItemMsg(hwnd, IDD_XRNAME,EM_SETTEXTLIMIT,
                                 MPFROM2SHORT(MAXXRNAME,0),NULL);
         WinSendDlgItemMsg(hwnd, IDD_XRVALUE,EM_SETTEXTLIMIT,
                                 MPFROM2SHORT(MAXXRVALUE,0),NULL);
         pPDat=PVOIDFROMMP(mp2);

         WinSetDlgItemText(hwnd, IDD_XRNAME,pPDat->Point);
         WinSetDlgItemText(hwnd, IDD_XRTYPE,ConvTable[usRetXRType].szFormat);
         WinSendDlgItemMsg(hwnd, IDD_NEEDBIT, BM_SETCHECK,
                           MPFROM2SHORT(pPDat->fFlag,0),NULL);

         if(szAscii)   /* Set default XR Value if global var is != NULL */
            WinSetDlgItemText(hwnd, IDD_XRVALUE,szAscii);

         if(pPDat->usIndex) /* Disable XRNAME if passed in a non-zero value */
         {
            WinEnableWindow(WinWindowFromID(hwnd,IDD_XRNAME),FALSE);
            WinEnableWindow(WinWindowFromID(hwnd,IDD_NEEDBIT),FALSE);
            WinSetFocus(HWND_DESKTOP,WinWindowFromID(hwnd,IDD_XRVALUE));
            return TRUE;       /* We don't want default focus setting */
         }
         return 0L;

      case WM_COMMAND:
         switch(COMMANDMSG(&msg)->cmd)
         {
            case DID_OK:
               pPDat->fFlag = (BYTE) WinSendDlgItemMsg(hwnd, IDD_NEEDBIT,
                                                       BM_QUERYCHECK,
                                                       0L, 0L);
               WinQueryDlgItemText(hwnd, IDD_XRNAME, MAXXRNAME+1, szXRName);

               if(!strlen(szXRName))    /* They nulled out the name */
               {
                  WinAlarm(HWND_DESKTOP,WA_ERROR);
                  WinMessageBox(HWND_DESKTOP, hwnd,
                                "Cannot create a NULL XR name.",
                                NULL, 0, MB_OK);
                  return 0L;
               }

               GetMem(szScratch,MAXXRVALUE+1);  /* Allocate buffer for value */
               WinQueryDlgItemText(hwnd, IDD_XRVALUE, MAXXRVALUE+1, szScratch);

               if(!strlen(szScratch))    /* They nulled out the value */
               {
                  FreeMem(szScratch,MAXXRVALUE+1); /* Free the value buffer */
                  WinAlarm(HWND_DESKTOP,WA_ERROR);
                  WinMessageBox(HWND_DESKTOP, hwnd,
                                "An XR can't have a NULL value.",
                                NULL, 0, MB_OK);
                  return 0L;
               }

               if(stricmp(szXRName,pPDat->Point)) /* changed the XR name */
               {
                  if(XRExists(szXRName))  /* Can't have duplicate XR names */
                  {
                     WinAlarm(HWND_DESKTOP,WA_ERROR);
                     WinMessageBox(HWND_DESKTOP, hwnd,
                            "XR name already exists.  Can't create that name.",
                            NULL, 0, MB_OK);

                     FreeMem(szScratch,MAXXRVALUE+1);  /* Free value buffer */
                     return 0L;
                  }
               }

               ResizeMem(szScratch,MAXXRVALUE+1,/* Resize buf to actual size */
                         strlen(szScratch)+1);

               WinDismissDlg(hwnd, TRUE);
               return 0L;

            case DID_CANCEL:
               WinDismissDlg(hwnd, FALSE);
               return 0L;
         }
         break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/*
 * Function name: IconDlgProc()
 *
 */

MRESULT EXPENTRY IconDlgProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   switch(msg)
   {
      case WM_INITDLG:
         return 0L;

      case WM_COMMAND:
         switch(COMMANDMSG(&msg)->cmd)
         {
            case DID_OK:
               WinDismissDlg(hwnd, TRUE);
               return 0L;
         }
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/*
 * Function name: MultiTypeProc()
 *
 */

MRESULT EXPENTRY MultiTypeProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
   static HOLDFXR *pFXR;        /* Points to the current XR         */
   static PASSDATA FAR *pPDat;  /* Points to the passed Data struct */
   static REENTER *CurEntry;    /* Points to most recent data frame */
   REENTER *ReEntHold;          /* Temp used to setup the frame     */
   PASSDATA PDat;               /* Used for call to EditXRValue     */
   USHORT *pusPtr,cnt;          /* Utility vars                     */
   SHORT  sOffset;
   CHAR   *pInsert,*pValue,*pDelete;
   CHAR   szCodePage[LENUSHORTBUF];
   BYTE   fNeed;                /* Holds state of need checkbox     */

   switch(msg)
   {
      case WM_INITDLG:
         pPDat = PVOIDFROMMP(mp2);             /* Set up static vars        */
         pFXR  = (HOLDFXR *) pPDat->Point;

         GetMem(ReEntHold,sizeof(REENTER));    /* Allows for recusive calls */
         ReEntHold->pPDat = pPDat;
         ReEntHold->pFXR  = pFXR;
         ReEntHold->next  = CurEntry;
         CurEntry = ReEntHold;

         WinSendDlgItemMsg(hwnd, IDD_NEEDBIT, BM_SETCHECK, /* Need bit setup */
                           MPFROM2SHORT((pFXR->fXR&0x80)? TRUE : FALSE,0),
                           NULL);

         WinSetDlgItemText(hwnd,IDD_XRTYPE,"");  /* Setup the codepage */
         WinSetDlgItemText(hwnd,IDD_XRNAME,pFXR->szName);
         WinSendDlgItemMsg(hwnd, IDD_CODEPAGE,EM_SETTEXTLIMIT,
                                 MPFROM2SHORT(LENUSHORTBUF-1,0),NULL);

         pusPtr= (USHORT *) ((CHAR *) pFXR->aValue+pPDat->usMultiOffset);
         pusPtr++;       /* Skip the XR_Type field and point to codepage */
         sprintf(szCodePage,"%u",*pusPtr);
         WinSetDlgItemText(hwnd, IDD_CODEPAGE,szCodePage);

         pusPtr++;      /* Skip codepage and point to the field count */

         for(cnt=0;cnt< *pusPtr;cnt++) /* Add each field to the L-Box */
         {
            pInsert = MultiTypeIndex(pFXR->aValue+pPDat->usMultiOffset,cnt);
            pValue = XRValueString(hwnd,pInsert); /* Ptr to asciiz string */

            WinSendDlgItemMsg(hwnd, IDD_LBOX, LM_INSERTITEM,
                              MPFROM2SHORT(LIT_END,0),
                              MPFROMP(pValue));
            FreeMem(pValue,strlen(pValue)+1);  /* Free asciiz string */
         }
         return 0L;

      case WM_CONTROL:
         switch(SHORT1FROMMP(mp1))
         {
            case IDD_LBOX:
               switch(SHORT2FROMMP(mp1))
               {
                  case LN_SELECT:   /* Display proper XR type for selection */
                     sOffset = (SHORT) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                                       LM_QUERYSELECTION,0,0);
                     if(sOffset<0)
                        break;

                     pValue = MultiTypeIndex(pFXR->aValue+pPDat->usMultiOffset,
                                             sOffset);
                     pusPtr = (USHORT *) pValue;

                     WinSetDlgItemText(hwnd,IDD_XRTYPE,
                                ConvTable[LookupXRType(*pusPtr)].szFormat);
                     break;

                  case LN_ENTER:  /* Setup and edit a m-m field */
                     sOffset = (SHORT) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                                       LM_QUERYSELECTION,0,0);
                     if(sOffset<0)
                        return 0L;

                     PDat.Point         = (CHAR *) pFXR; /* Pass curr data */
                     PDat.cbMulti       = pPDat->cbMulti;
                     PDat.usMultiOffset = pPDat->usMultiOffset;
                     PDat.usIndex       = (USHORT) sOffset;

                     if(EditXRValue(hwnd,&PDat)) /* They didn't cancel */
                     {
                        pInsert=MultiTypeIndex(pFXR->aValue
                                                + pPDat->usMultiOffset,
                                               sOffset);
                        pValue =XRValueString(hwnd,pInsert);

                        WinSendDlgItemMsg(hwnd, IDD_LBOX, LM_SETITEMTEXT,
                                          MPFROMSHORT(sOffset),
                                          MPFROMP(pValue));
                        FreeMem(pValue,strlen(pValue)+1); /* Free asciiz str */
                     }
                     return 0L;
               }
         }

      case WM_COMMAND:
         switch(COMMANDMSG(&msg)->cmd)
         {
            case IDD_ADD:                  /* Add an item for a m-m */
               MultiAdd(hwnd, pFXR,pPDat);
               return 0L;

            case IDD_EDIT:  /* Setup and edit a m-m field */
               sOffset = (SHORT) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                                   LM_QUERYSELECTION,0,0);
               if(sOffset<0)
                  return 0L;

               PDat.Point         = (CHAR *) pFXR; /* Pass curr data */
               PDat.cbMulti       = pPDat->cbMulti;
               PDat.usMultiOffset = pPDat->usMultiOffset;
               PDat.usIndex       = (USHORT) sOffset;

               if(EditXRValue(hwnd,&PDat)) /* They didn't cancel */
               {
                  pInsert=MultiTypeIndex(pFXR->aValue + pPDat->usMultiOffset,
                                         sOffset);
                  pValue =XRValueString(hwnd,pInsert);

                  WinSendDlgItemMsg(hwnd, IDD_LBOX, LM_SETITEMTEXT,
                                    MPFROMSHORT(sOffset),
                                    MPFROMP(pValue));
                  FreeMem(pValue,strlen(pValue)+1); /* Free asciiz str */
               }
               return 0L;

            case IDD_DELETE:               /* Delete hi-lited item  */
               sOffset = (USHORT) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                                    LM_QUERYSELECTION,0,0);
               if(sOffset<0)   /* No item is currently selected */
                  return 0L;

               WinSendDlgItemMsg(hwnd, IDD_LBOX, LM_DELETEITEM,
                                 MPFROMSHORT(sOffset),0L);

               /* Get pointers to start of selected field and the following
                  field, then move the rest of the XR back, resize the
                  buffer, and change the XR Value counter                  */

               pDelete = MultiTypeIndex(pFXR->aValue+pPDat->usMultiOffset,
                                        sOffset);
               pValue  = MultiTypeIndex(pFXR->aValue+pPDat->usMultiOffset,
                                        sOffset+1);
               memmove(pDelete,pValue,pFXR->cbValue-(pValue-pFXR->aValue));
               ResizeMem(pFXR->aValue,pFXR->cbValue,
                         pFXR->cbValue-(pValue-pDelete));
               pFXR->cbValue -= pValue-pDelete;

               /* Decrement the field count in the m-m */
               pusPtr  = (USHORT *) ((CHAR *) pFXR->aValue +
                                              pPDat->usMultiOffset);
               pusPtr+=2;         /* Point to the field count */
               *pusPtr -= 1;      /* Decrement the field cnt  */

               FILE_CHANGED = TRUE;
               return 0L;

            case DID_DONE:
               /* Handle the possible change of the need checkbox */
               fNeed = (BYTE) WinSendDlgItemMsg(hwnd, IDD_NEEDBIT,
                                                BM_QUERYCHECK,
                                                0L, 0L);
               if(fNeed)
                  fNeed = 0x80;
               if(fNeed != (pFXR->fXR & 0x80)) /* Need changed */
               {
                  pFXR->fXR = (pFXR->fXR & 0x7F) | fNeed;
                  FILE_CHANGED = TRUE;
               }

               /* Handle the possible change of the codepage */
               WinQueryDlgItemText(hwnd, IDD_CODEPAGE,
                                   LENUSHORTBUF, szCodePage);
               sscanf(szCodePage,"%u",&cnt);
               pusPtr= (USHORT *) ((CHAR *) pFXR->aValue+pPDat->usMultiOffset);
               pusPtr++;    /* Skip the XR_Type field and point to codepage */
               if(*pusPtr != cnt) /* They changed the codepage value */
               {
                  *pusPtr = cnt;
                  FILE_CHANGED = TRUE;
               }

               ReEntHold = CurEntry->next;       /* Finish recursion safety */
               FreeMem(CurEntry,sizeof(REENTER));
               CurEntry = ReEntHold;
               if(CurEntry)
               {
                  pPDat = CurEntry->pPDat;
                  pFXR  = CurEntry->pFXR;
               }
               WinDismissDlg(hwnd, TRUE);
               return 0L;
         }
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


/*
 * Function name: ShowXRType()
 *
 */

VOID ShowXRType(HWND hwnd)
{
   USHORT usXRType;         /* Holds the offset of XRType into ConvTable */
   HOLDFXR *pFXR;

   pFXR = GetCurFXR(hwnd,pHoldFXR); /* Points to the selected XR */
   if(!pFXR)                        /* Kill line if nothing is selected */
   {
      WinSetDlgItemText(hwnd,IDD_XRTYPE,"");
      return;
   }
   usXRType = LookupXRType((USHORT) *pFXR->aValue);

   WinSetDlgItemText(hwnd,IDD_XRTYPE,ConvTable[usXRType].szFormat);
}



/*
 * Function name: EditXR()
 *
 */

BOOL EditXR(HWND hwnd)
{
   HOLDFXR *pFXR=pHoldFXR;  /* Pointer for selected XR */
   LONG offset,lCnt;        /* Both used to reference offset of selected XR */
   PASSDATA PData;

   if(!FILE_ISOPEN)
      return(FALSE);

   offset = lCnt = (LONG) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                            LM_QUERYSELECTION,0,0);

   if(offset<0)        /* Nothing was selected */
      return(FALSE);

   while(lCnt--)         /* Get to the right XR */
      pFXR = pFXR->next;

   PData.Point         = (CHAR *) pFXR;        /* Set the pass data struct */
   PData.usMultiOffset = 0;
   PData.cbMulti       = 0;

   if(EditXRValue(hwnd,&PData))  /* It worked */
   {
      WinSendDlgItemMsg(hwnd, IDD_LBOX,LM_SETITEMTEXT,
                        MPFROMSHORT((SHORT) offset),MPFROMP(pFXR->szName));
      return(TRUE);
   }
   return(FALSE);
}


/*
 * Function name: GetCurFXR()
 *
 */

HOLDFXR *GetCurFXR(HWND hwnd, HOLDFXR *pFXR)
{
   LONG lOffset;

   lOffset = (LONG) WinSendDlgItemMsg(hwnd, IDD_LBOX,
                                      LM_QUERYSELECTION,0,0);

   if(lOffset<0)      /* Nothing is highlighted */
      return(NULL);

   while(lOffset--)
   {
      pFXR = pFXR->next;
   }

   return(pFXR);
}
/************************************/
/************************************/
/************************************/
