rem dlncat.sql
rem
rem Create DATALENS_OBJECTS view on ORACLE v6 system tables.
rem

drop view DATALENS_OBJECTS
/
create view DATALENS_OBJECTS
    (OBJ_OWNER,
     OBJ_NAME,
     OBJ_TYPE,
     OBJ_COMMENT,
     SYN_TAB_OWNER,
     SYN_TAB_NAME,
     NUM_OF_COL)
as
select u.name,
       o.name,
       decode(o.type, 2, 1,                     /* table */
                      4, 2,                     /* view */
                      5, decode(owner#, 1, 4,   /* public synonym */
                                           3    /* synonym */ ),
                         NULL),
       c.comment$,
       decode(o.type, 5, s.owner,
                         NULL),
       decode(o.type, 5, s.name,
                         NULL),
       decode(o.type, 2, t.cols,
                      4, v.cols, 0)
from sys.obj$ o, sys.user$ u, sys.com$ c, sys.tab$ t, sys.view$ v, sys.syn$ s
where o.owner# = u.user#
  and o.obj# = t.obj#(+)
  and o.obj# = v.obj#(+)
  and o.obj# = c.obj#(+)
  and o.obj# = s.obj#(+)
  and c.col#(+) is null
  and o.type in (2,4,5)
  and (o.owner# = uid
       or
       o.obj# in (select obj#
                    from sys.tabauth$
                    where grantee# in (uid, 1)))
/
drop public synonym DATALENS_OBJECTS
/
create public synonym DATALENS_OBJECTS for DATALENS_OBJECTS
/
grant select on DATALENS_OBJECTS to PUBLIC
/
