/* Build indexes for CELDIAL tables with foreign keys */
/*************************************************************************
   Written by Steve Goldwasser, Marketing Development & Sales,
              PRGS Toronto Laboratory
              February 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Mar 22 - add option to defer referential constraints to here
 *        - convert to CEL prefix
 * Jun  8 - add table PRODINV
 *************************************************************************/
/************************************************
  Initialize required variables
 ************************************************/
 True=(1=1); False=(0=1)
/**************************************************************
   Register SQLEXEC routine
 **************************************************************/
 If Rxfuncquery('SQLEXEC') <>0 then
    do; rcy = Rxfuncadd('SQLEXEC','SQLAR','SQLEXEC')
   /*   say 'RC from Rxfuncadd is' rcy  */
        end
 parse upper arg nolog nexttab debug reflast
 if debug='DEBUG' then debug=true; else debug=false
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
 if nolog <> 'NOLOG' then call connect

if (nexttab <> '' & nexttab <> '.') then interpret 'signal' nexttab

CUSTOMER:
      call cust
      if (nexttab <> '' & nexttab <> '.') then signal commexit
PRODUCT:
      call prod
      if (nexttab <> '' & nexttab <> '.') then signal commexit
COMPONENTS:
      call comp
      if (nexttab <> '' & nexttab <> '.') then signal commexit
ORDERS:
      call ord
      if (nexttab <> '' & nexttab <> '.') then signal commexit
ARHIST:
      call arh
      if (nexttab <> '' & nexttab <> '.') then signal commexit
BITMAPS: nop

commexit:
      exit 0
/*************end-of-mainline *********************/

connect:
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
'@ECHO OFF';
 say 'Logging on as USERID locally'
'LOGON USERID /L /P='
 if rc<>0 then do;
    say 'Logon failed, RC='rc', fix & restart'
    exit
    end

 say 'Connecting to CELDIAL database'
 call DBM '-O CONNECT TO CELDIAL'
 if rc<>0 then do;
    say 'Connect failed, RC='rc', fix & restart'
    exit 4
    end
 return

cust:
 if reflast='REFLAST' then ,
 do; say 'Building primary key on CUSTOMER table'
     call DBM 'ALTER TABLE CUSTOMER PRIMARY KEY (CUSTNO)'
     say 'Building primary key on CUSTSHIP table'
     call DBM 'ALTER TABLE CUSTSHIP PRIMARY KEY (CUSTNO,SHIPID)'
     say 'Defining referential constraint for CUSTSHIP table'
     call DBM 'ALTER TABLE CUSTSHIP FOREIGN KEY CUSTFK1 (CUSTNO)',
              '           REFERENCES CUSTOMER ON DELETE RESTRICT'
     end
 say
 say 'Building index for CUSTSHIP table'
 call DBM '-O DROP INDEX CUST_FK1'
 call DBM 'CREATE  INDEX CUST_FK1 ON CUSTSHIP (CUSTNO ASC)'
 call SQLEXEC 'COMMIT'
 return

prod:
 say
 if reflast='REFLAST' then ,
 do; say 'Building primary key on PRODSHOW table'
     call DBM 'ALTER TABLE PRODSHOW PRIMARY KEY (PARTNO)'
     say 'Building primary key on PRODUCT  table'
     call DBM 'ALTER TABLE PRODUCT PRIMARY KEY (PARTNO,MODEL)'
     say 'Defining referential constraint for PRODUCT table'
     call DBM 'ALTER TABLE PRODUCT FOREIGN KEY PRODFK1 (PARTNO)' ,
              '           REFERENCES PRODSHOW ON DELETE RESTRICT'
     say 'Defining referential constraint for PRODINV table'
     call DBM 'ALTER TABLE PRODINV FOREIGN KEY PRODFK2 (PARTNO,MODEL)',
              '           REFERENCES PRODUCT  ON DELETE RESTRICT'
     end
 say 'Building indexes for PRODUCT tables'
 call DBM '-O DROP INDEX PROD_FK1'
 call DBM '-O DROP INDEX PROD_FK2'
 call DBM 'CREATE  INDEX PROD_FK1 ON PRODUCT (PARTNO ASC)'
 call DBM 'CREATE  INDEX PROD_FK2 ON PRODINV (PARTNO ASC, MODEL ASC)'
 call SQLEXEC 'COMMIT'
 return

ord:
 say
 if reflast='REFLAST' then ,
 do; say 'Building primary key on ORDER_SUMMARY table'
     call DBM 'ALTER TABLE ORDER_SUMMARY PRIMARY KEY (ORDERREF)'
     say 'Defining referential constraint for ORDER_SUMMARY table'
     call DBM 'ALTER TABLE ORDER_SUMMARY FOREIGN KEY ORDERFK1 (CUSTNO,SHIPID)' ,
              '           REFERENCES CUSTSHIP ON DELETE RESTRICT'
     say 'Defining referential constraints for ORDER_DETAIL table'
     call DBM 'ALTER TABLE ORDER_DETAIL FOREIGN KEY ORDERFK2 (ORDERREF)' ,
              '           REFERENCES ORDER_SUMMARY ON DELETE RESTRICT'
     call DBM 'ALTER TABLE ORDER_DETAIL FOREIGN KEY ORDERFK3 (PARTNO,MODEL)' ,
              '           REFERENCES PRODUCT   ON DELETE RESTRICT'
     say 'Defining referential constraint for ORDER_HIST_SUM table'
     call DBM 'ALTER TABLE ORDER_HIST_SUM FOREIGN KEY ORDERFK4 (CUSTNO,SHIPID)' ,
              '           REFERENCES CUSTSHIP ON DELETE RESTRICT'
     say 'Defining referential constraint for ORDER_HIST_DET table'
     call DBM 'ALTER TABLE ORDER_HIST_DET FOREIGN KEY ORDERFK5 (PARTNO,MODEL)' ,
              '           REFERENCES PRODUCT ON DELETE RESTRICT'
     end
 say 'Building indexes for ORDER tables'
 call DBM '-O DROP INDEX ORDSUM_FK1'
 call DBM '-O DROP INDEX ORDDET_FK2'
 call DBM '-O DROP INDEX ORDDET_FK3'
 call DBM '-O DROP INDEX ORDHIS_FK4'
 call DBM '-O DROP INDEX ORDHIS_FK5'

 call DBM 'CREATE  INDEX ORDSUM_FK1 ON ORDER_SUMMARY  (CUSTNO ASC, SHIPID ASC)'
 call DBM 'CREATE  INDEX ORDDET_FK2 ON ORDER_DETAIL   (ORDERREF ASC)'
 call DBM 'CREATE  INDEX ORDDET_FK3 ON ORDER_DETAIL   (PARTNO  ASC)'
 call DBM 'CREATE  INDEX ORDHIS_FK4 ON ORDER_HIST_SUM (CUSTNO  ASC, SHIPID ASC)'
 call DBM 'CREATE  INDEX ORDHIS_FK5 ON ORDER_HIST_DET (PARTNO)'
 call SQLEXEC 'COMMIT'
 return

arh:
 say
 if reflast='REFLAST' then ,
 do; say 'Defining referential constraint for AR_HISTORY table'
     call DBM 'ALTER TABLE AR_HISTORY FOREIGN KEY AR_FK1 (CUSTNO,SHIPID)' ,
              '           REFERENCES CUSTSHIP ON DELETE RESTRICT'
     end
 say 'Building index for AR_HISTORY table'
 call DBM '-O DROP INDEX ARHIS_FK5'
 call DBM 'CREATE  INDEX ARHIS_FK5 ON AR_HISTORY (CUSTNO ASC, SHIPID ASC)'
 call SQLEXEC 'COMMIT'
 return

comp:
 say
 if reflast='REFLAST' then ,
 do; say 'Building primary key on COMPONENTS table'
     call DBM 'ALTER TABLE COMPONENTS PRIMARY KEY (COMPNO)'
     say 'Defining referential constraints for PRODCOMP table'
     call DBM 'ALTER TABLE PRODCOMP FOREIGN KEY COMPFK1 (PARTNO,MODEL)' ,
              '           REFERENCES PRODUCT ON DELETE RESTRICT'
     call DBM 'ALTER TABLE PRODCOMP FOREIGN KEY COMPFK2 (COMPNO)' ,
              '           REFERENCES COMPONENTS ON DELETE RESTRICT'
     end
 say 'Building indexes for PRODCOMP table'
 call DBM '-O DROP INDEX COMP_FK1'
 call DBM '-O DROP INDEX COMP_FK2'

 call DBM 'CREATE  INDEX COMP_FK1 ON PRODCOMP (PARTNO ASC, MODEL ASC)'
 call DBM 'CREATE  INDEX COMP_FK2 ON PRODCOMP (COMPNO ASC)'
 call SQLEXEC 'COMMIT'
 return
