/* Create CelDial Database with data from supplied data files */
/*************************************************************************
   Written by Steve Goldwasser, Marketing Development & Sales,
              PRGS Toronto Laboratory
              February 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Mar  8 - add date conversions & RUNSTATS
 * Mar 22 - change company name to CelDial
 * Mar 25 - add STARTDBM & CREATE DATABASE
 * Jun  8 - add PRODINV table
 *************************************************************************/
 arg format nolog nexttab del reflast debug

 if debug   = '' then debug   = '.'
 if reflast = '' then reflast = '.'
 if del     = '' then del     = '.'
 if nexttab = '' then nexttab = '.'
 if nolog   = '' then nolog   = '.'
 if format  = '' then format  = '.'

 if nolog = '?' | ,
   (format<>'EUR' & format<>'ISO' & format<>'JIS' & format<>'.') then ,
   do; say 'Syntax is CELDIAL <.|EUR|ISO|JIS .|NOLOG|?  .|nexttab  .|DEL|DROP .|REFLAST .|DEBUG >'
       say
       say 'EUR,ISO,JIS convert data formats before load to format specified'
       say
       say 'NOLOG bypasses logon & connect to CELDIAL database.'
       say
       say 'nexttab is used only for adding table(s) to an existing DB.'
       say 'Use for dropping & recreating existing tables will destroy'
       say 'referential constraints on tables not dropped.'
       say
       say 'DEL bypasses create of tables and empties tables before reloading data'
       say
       say 'DROP causes recreate by dropping tables before create;'
       say '     used if refreshing an existing database'
       say '          or refreshing a specific table group.'
       say
       say 'REFLAST - referential constraints to be imposed after data load'
       say
       say 'DEBUG causes additional status messages during execution.'
       say
       say '. is used to bypass positional parameters'
       say
       say 'Trailing .'s are not required
       exit
       end

start: 'CLS'; say
say '   Assumptions:'
say
say '      1. USERID userid defined in UPM, at least local administrator'
say '      2. USERID password known, to be prompted'
say
say '   If any of the above assumptions are incorrect, answer N to the following:'
say
say '   Are all assumptions above valid (Y/N)?'; pull answer
select;  when substr(answer,1,1)= 'Y' then 'CLS'
         when substr(answer,1,1)= 'N' then ,
            do; say '   Correct any invalid assumptions above and rerun'; say
                exit 4
                end
         otherwise signal start /* Ask again */
         end  /* select */

 true = (0=0); false= (0=1)
 result = 0

 if nolog<>'NOLOG' then
   do; call dbmstart  /* STARTDBM if not yet started */
       call identify  /* LOGON as USERID             */
       call connect   /* CONNECT to CELDIAL          */
       end
 else say 'Skipped LOGON USERID & CONNECT TO CELDIAL'

/*** Create table definitions ***/

 if del <> 'DEL' then , /* Bypass create if DEL specified */
 do; rtn='CELDEF NOLOG 'nexttab' 'del' 'debug' 'reflast
     call CELDEF 'NOLOG' nexttab del debug reflast
     if result <> 0 then signal errexit
     end

/*** Convert data if necessary for NLS ***/
 if format<>'' & format <> '.' then ,
 do; rtn='CELCONV 'format' 'debug
     call CELCONV format debug
     end

/*** Add data to tables ***/
 if del <> 'DEL' then del='.'  /* DEL not required if table(s) DROPped */
 rtn='CELADD NOLOG 'nexttab' 'del' 'format' 'debug
 call CELADD 'NOLOG' nexttab del format debug
 if result <> 0 then signal errexit

 if reflast = '.' then ,
 do; /*** Define indexes on Foreign keys and for performance ***/
     rtn='CELIDX NOLOG 'nexttab' 'debug' 'reflast
     call CELIDX 'NOLOG' nexttab debug reflast
     if result <> 0 then signal errexit

     /*** RUNSTATS on all tables ***/
     rtn='CELSTAT NOLOG 'nexttab' 'debug
     call CELSTAT 'NOLOG' nexttab debug
     if result <> 0 then signal errexit
     end

commexit:
 if nolog <> 'NOLOG' then ,
    do; call DBM 'CONNECT RESET'
        if stopdbm then 'STOPDBM'
       'LOGOFF /L'
        end
 exit result

dbmstart:
   'STARTDBM'  /* make sure DBM is active */
    if rc = 0 then stopdbm = true  /* OK, plan to STOPDBM */
    else ,
    if rc<>1 then
      do; say 'STARTDBM failed, repair problem and restart'
          exit
          end /* do */
      else stopdbm = false  /* DBM previously started, leave status quo */
    return

identify:
   '@ECHO OFF';
    say 'Logging on as USERID locally'
   'LOGON USERID /L /P='
    if rc<>0 then do;
       say 'Logon failed, RC='rc', fix & restart'
       exit 8
       end
    return

connect: 
    say 'Connecting to CELDIAL database'
reconnect:
    call DBM '-O CONNECT TO CELDIAL'
    if result<>0 then ,
       if result <> -1013 & result <> -1031 then ,
         do; say 'Connect failed with rc' result', fix & restart'
             exit 8
             end
       else do; call createdb /* -1013 => db does not exist */
                              /* -1031 => no db created yet */
                signal reconnect
                end
    return

createdb:
    say
    say 'CELDIAL database does not yet exist.'
createloop:
    say
    say 'Press Enter to default to the C: disk  or'
    say 'Type the disk letter (c-p) for me to create one, and press Enter  or'
    say 'Press Q and Enter to Quit'
    pull disk .
    if disk = '' then disk='C'
       else disk=substr(disk,1,1)
    if disk<'B' | disk>'P' then ,
       if disk='Q' then exit
       else signal createloop
    call DBM 'CREATE DATABASE CELDIAL ON' disk,
             ' WITH "CelDial Corporation Database"'
    if result<>0 then exit 8
    return

errexit:
    say 'Routine invoked - 'rtn
    say 'returned error code' result
    say
    say 'Correct problem if possible, or report problem to author of package'
    say 'for resolution.'
    signal commexit
