/* Create CelDial Corporation DB2/2 tables - Version 1.2 */
/*************************************************************************
   Written by Steve Goldwasser, Marketing Development & Sales,
              PRGS Toronto Laboratory
              February 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Mar22 - change company name to CelDial
 *       - add views CUSTALL     PRODALL         ORDER_ALL
 *                   CUST_ORDER  ORDER_HIST_ALL  CUST_ORDER_HIST
 *                   PRODBOM
 * Jun08 - add table PRODINV
 *************************************************************************/
'@ECHO OFF'
arg log nexttab drop debug reflast
if log = '?' then ,
   do; say 'Syntax is CELDEF <.|NOLOG|?  .|nexttab  .|DROP  .|DEBUG  <.|REFLAST> >'
       say
       say 'NOLOG bypasses logon & connect to CELDIAL database.'
       say
       say 'nexttab is used only for adding table(s) to an existing DB.'
       say 'Use for dropping & recreating existing tables will destroy'
       say 'referential constraints on tables not dropped.'
       say
       say 'DROP causes recreate by dropping tables before create;'
       say '     used if refreshing an existing database'
       say '          or refreshing a specific table group.'
       say
       say 'DEBUG causes additional status messages during execution.'
       say
       say 'REFLAST - referential constraints to be imposed after data load'
       say
       say '. is used to bypass positional parameters'
       exit
       end

exitrc=0
if log<>'NOLOG' then call logon

tabdef.1 = 'CUSTOMER'
tabdef.2 = 'PRODUCT'
tabdef.3 = 'COMPONENTS'
tabdef.4 = 'ORDERS'
tabdef.5 = 'ARHIST'
tabdef.0=5

do tab = 1 to tabdef.0
   if (nexttab = '' | nexttab = '.' | nexttab = tabdef.tab) then ,
      interpret 'call' tabdef.tab
   end

commexit:
 call DBM 'COMMIT'
 exit exitrc

/************* Subroutines **************************/

logon:
    say 'Logging on as USERID locally'
   'LOGON USERID /L /P='
    if rc<>0 then do;
       say 'Logon failed, RC='rc', fix & restart'
       exit 8
       end

    say 'Starting DB2/2 Database Manager, if not already started'
   'STARTDBM > NUL'  /* ignore errors, catch these later */

    say 'Connecting to CELDIAL database'
    call DBM '-O CONNECT TO CELDIAL'
    if result<>0 then do;
       say 'Connect failed, RC='result', fix & restart'
       exit 8
       end
    return

CUSTOMER:
    tbl='CUSTOMER'
    if reflast='REFLAST' then pkey = ''
       else                   pkey =',PRIMARY KEY (CUSTNO)'
    tbldef='CREATE TABLE CUSTOMER (',
      ' CUSTNO        CHAR(7)  NOT NULL', /*CelDial Customer Number*/
      ',CUSTNAME      CHAR(40) NOT NULL', /*Customer/Company Name  */
      ',REPNO         CHAR(5) ',          /*CelDial Rep Identifier */
      ',CONTACT       CHAR(30)',          /*Contact Name           */
      ',CON_PHONE     CHAR(17)',          /*Contact Telephone      */
      ',CON_FAX       CHAR(17)',          /*Contact Fax Number     */
      ',CON_ADDR      CHAR(40)',          /*Contact Address        */
      ',CON_CITY      CHAR(30)',
      ',CON_COUNTRY   CHAR(20)',
      ',CON_ZIP       CHAR(10)',          /*Zip/Postal Code        */
      ',CON_ZIPLOC    CHAR(1)',           /*Position of ZIP, 1|2|3 */
      || pkey ||,
      ' )'                                /*end-of-table def       */
    call tabcreat

    tbl='CUSTSHIP'
    if reflast='REFLAST' then parse value '' with pkey fkey
       else do
          pkey =',PRIMARY KEY (CUSTNO,SHIPID)'
          fkey =',FOREIGN KEY CUSTFK1 (CUSTNO) REFERENCES CUSTOMER ON DELETE RESTRICT'
          end
    tbldef='CREATE TABLE CUSTSHIP (',
      ' CUSTNO        CHAR(7)  NOT NULL', /* CelDial Customer Number */
      ',SHIPID        CHAR(2)  NOT NULL', /* Ship location identifier*/
      ',SHIP_ADDR     CHAR(40)',          /* Ship-to Address         */
      ',SHIP_CITY     CHAR(30)',                                     
      ',SHIP_COUNTRY  CHAR(20)',                                     
      ',SHIP_ZIP      CHAR(10)',          /*Zip/Postal Code          */
      ',SHIP_ZIPLOC   CHAR(1)',           /*Position of ZIP, 1|2|3   */
      ',BILL_ADDR     CHAR(40)',          /*Bill-to Address          */
      ',BILL_CITY     CHAR(30)',                                       
      ',BILL_COUNTRY  CHAR(20)',                                       
      ',BILL_ZIP      CHAR(10)',          /*Zip/Postal Code          */
      ',BILL_ZIPLOC   CHAR(1)',           /*Position of ZIP, 1|2|3   */
      ||pkey ,
      ||fkey ,
      ||'  )'                               /* end-of-table def        */
    call tabcreat

    tbl='CUSTALL'
    tbldef='CREATE VIEW CUSTALL ',
      ' AS SELECT X.CUSTNO,CUSTNAME,REPNO,CONTACT,CON_PHONE,CON_FAX',
      '          ,CON_ADDR, CON_CITY, CON_COUNTRY, CON_ZIP, CON_ZIPLOC',
      ',Y.SHIPID,SHIP_ADDR,SHIP_CITY,SHIP_COUNTRY,SHIP_ZIP,SHIP_ZIPLOC',
      '         ,BILL_ADDR,BILL_CITY,BILL_COUNTRY,BILL_ZIP,BILL_ZIPLOC',
      ' FROM CUSTOMER X, CUSTSHIP Y ',
      'WHERE X.CUSTNO = Y.CUSTNO'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave
    return

PRODUCT:
    tbl='PRODSHOW'
    if reflast='REFLAST' then pkey = ''
       else pkey=',PRIMARY KEY (PARTNO)'
    tbldef='CREATE TABLE PRODSHOW (',
      ' PARTNO        CHAR(5)  NOT NULL', /* Part Number             */
      ',PARTDESC      CHAR(20)    ',      /* Description             */
      ',PARTPIC  LONG VARCHAR FOR BIT DATA', /* Bit map image of product*/
      ||pkey ,
      ||'  )'                             /*end-of-table def         */
    call tabcreat

    tbl='PRODUCT'
    if reflast='REFLAST' then parse value '' with pkey fkey
       else do
          pkey =',PRIMARY KEY (PARTNO,MODEL)'
          fkey =',FOREIGN KEY PRODFK1 (PARTNO) REFERENCES PRODSHOW ON DELETE RESTRICT'
          end
    tbldef='CREATE TABLE PRODUCT (',
      ' PARTNO        CHAR(5)  NOT NULL', /* Part Number             */
      ',MODEL         CHAR(5)  NOT NULL', /* Model Number            */
      ',PARTPRICE     DECIMAL(7,2)',      /*Suggested Wholesale Price*/
      ',PARTMSR       DECIMAL(7,2)',      /*Suggested Retail Price   */
      ',PARTDISC      CHAR(1)',  /*Eligible for volume discount (Y/N)*/
      ',PARTSHIPDATE  DATE',              /*First Ship Date          */
      ||pkey ,
      ||fkey ,
      ||'  )'                             /*end-of-table def         */
    call tabcreat

    tbl='PRODALL'
    tbldef='CREATE VIEW PRODALL',
      ' AS SELECT  X.PARTNO,PARTDESC,PARTPIC,',
      '            Y.MODEL,PARTPRICE,PARTMSR,PARTDISC,PARTSHIPDATE',
      '      FROM PRODSHOW X, PRODUCT Y ',
      '     WHERE X.PARTNO = Y.PARTNO'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    tbl='PRODINV'
    if reflast='REFLAST' then fkey=''
       else fkey =',FOREIGN KEY PRODFK2 (PARTNO,MODEL) REFERENCES PRODUCT ON DELETE RESTRICT'
    tbldef='CREATE TABLE PRODINV (',
      ' PARTNO        CHAR(5)  NOT NULL',
      ',MODEL         CHAR(5)  NOT NULL',
      ',INVENTORY     SMALLINT',
      ',RESTOCK       SMALLINT',
      ',RESTOCK_LEAD_DAYS SMALLINT',
      ||fkey ,
      ||'  )'                             /*end-of-table def         */
    call tabcreat
                                                                         
    return

ORDERS:
    tbl='ORDER_SUMMARY'
    if reflast='REFLAST' then parse value '' with pkey fkey
       else do
          pkey =',PRIMARY KEY (ORDERREF)'
          fkey =',FOREIGN KEY ORDERFK1 (CUSTNO,SHIPID) REFERENCES CUSTSHIP ON DELETE RESTRICT'
          end
    tbldef='CREATE TABLE ORDER_SUMMARY (',
      ' ORDERREF      CHAR(5)  NOT NULL', /*Order Reference Number   */
      ',CUSTNO        CHAR(7)  NOT NULL', /*CelDial Customer Number  */
      ',SHIPID        CHAR(2)  NOT NULL', /*Ship location identifier */
      ',ORDERDATE     DATE',              /*Order Date               */
      ',CUSTSHIPDATE  DATE',           /*Customer Requested Ship Date*/
      ',PLANSHIPDATE  DATE',              /*Planned Ship Date        */
      ',STATUS        CHAR(2)',           /*Order Status             */
      ',COMMENTS      VARCHAR(80)',       /*Comments                 */
      ||pkey ,
      ||fkey ,
      ||'  )'                             /*end-of-table def       */
    call tabcreat

    tbl='ORDER_DETAIL'
    if reflast='REFLAST' then parse value '' with fkey fkey2
       else do
          fkey =',FOREIGN KEY ORDERFK2 (ORDERREF) REFERENCES ORDER_SUMMARY ON DELETE RESTRICT'
          fkey2=',FOREIGN KEY ORDERFK3 (PARTNO,MODEL) REFERENCES PRODUCT   ON DELETE RESTRICT'
          end
    tbldef='CREATE TABLE ORDER_DETAIL (',
      ' ORDERREF      CHAR(5)  NOT NULL',  /*Order Reference Number */
      ',PARTNO        CHAR(5)  NOT NULL',  /*Part Number            */
      ',MODEL         CHAR(5)  NOT NULL',  /*Model Number           */
      ',PARTPRICE     DECIMAL(7,2)',       /*Unit Selling Price Negotiated*/
      ',UNITS         SMALLINT',           /*Number of Units Ordered*/
      ||fkey ,
      ||fkey2 ,
      ||'  )'                              /*end-of-table def       */
    call tabcreat

    tbl='ORDER_ALL'
    tbldef='CREATE VIEW ORDER_ALL',
           ' AS SELECT X.ORDERREF,CUSTNO,SHIPID,ORDERDATE,CUSTSHIPDATE,PLANSHIPDATE,STATUS,COMMENTS',
           '          ,Y.PARTNO,Y.MODEL,PARTPRICE,UNITS',
           '      FROM ORDER_SUMMARY X, ORDER_DETAIL Y',
           '     WHERE X.ORDERREF = Y.ORDERREF'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    tbl='CUST_ORDER'     /* List of Customers with outstanding orders */
    tbldef='CREATE VIEW CUST_ORDER',
           ' AS SELECT X.CUSTNO,Y.ORDERREF',
           '      FROM CUSTOMER X, ORDER_SUMMARY Y',
           '     WHERE X.CUSTNO = Y.CUSTNO'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    tbl='ORDER_HIST_SUM'
    if reflast='REFLAST' then fkey=''
       else fkey =',FOREIGN KEY ORDERFK4 (CUSTNO,SHIPID) REFERENCES CUSTSHIP ON DELETE RESTRICT'
    tbldef='CREATE TABLE ORDER_HIST_SUM (',
      ' ORDERREF      CHAR(5)  NOT NULL', /*Order Reference Number  */
      ',CUSTNO        CHAR(7)  NOT NULL', /*CelDial Customer Number */
      ',SHIPID        CHAR(2)  NOT NULL', /*Ship location identifier*/
      ',ORDERDATE     DATE',              /*Order Date              */
      ',CUSTSHIPDATE  DATE',          /*Customer Requested Ship Date*/
      ',PLANSHIPDATE  DATE',              /*Planned Ship Date       */
      ',ACTSHIPDATE   DATE',              /*Actual Ship Date        */
      ',COMMENTS      VARCHAR(80)',       /*Comments                */
      ||fkey ,
      ||'  )'                             /*end-of-table def       */
    call tabcreat

    tbl='ORDER_HIST_DET'
    if reflast='REFLAST' then fkey=''
       else fkey =',FOREIGN KEY ORDERFK5 (PARTNO,MODEL) REFERENCES PRODUCT ON DELETE RESTRICT'
    tbldef='CREATE TABLE ORDER_HIST_DET (',
      ' ORDERREF      CHAR(5)  NOT NULL', /*Order Reference Number  */
      ',PARTNO        CHAR(5)  NOT NULL', /*Part Number             */
      ',MODEL         CHAR(5)  NOT NULL', /* Model Number           */
      ',PARTPRICE     DECIMAL(7,2)',  /*Unit Selling Price Negotiated*/
      ',UNITS         SMALLINT',          /*Number of Units Ordered */
      ||fkey ,
      ||'  )'                             /*end-of-table def        */
    call tabcreat

    tbl='ORDER_HIST_ALL'
    tbldef='CREATE VIEW ORDER_HIST_ALL ',
           ' AS SELECT X.ORDERREF,CUSTNO,SHIPID,ORDERDATE,CUSTSHIPDATE,PLANSHIPDATE,ACTSHIPDATE,COMMENTS',
           '          ,Y.PARTNO,Y.MODEL,PARTPRICE,UNITS',
           '      FROM ORDER_HIST_SUM X, ORDER_HIST_DET Y',
           '     WHERE X.ORDERREF = Y.ORDERREF'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    tbl='CUST_ORDER_HIST'     /* List of Customers with order history */
    tbldef='CREATE VIEW CUST_ORDER_HIST',
           ' AS SELECT X.CUSTNO,Y.ORDERREF',
           '      FROM CUSTOMER X, ORDER_HIST_SUM Y',
           '     WHERE X.CUSTNO = Y.CUSTNO'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    return

ARHIST:
    tbl='AR_HISTORY'
    if reflast='REFLAST' then fkey=''
       else fkey =',FOREIGN KEY AR_FK1 (CUSTNO,SHIPID) REFERENCES CUSTSHIP ON DELETE RESTRICT'
    tbldef='CREATE TABLE AR_HISTORY (',
      ' CUSTNO        CHAR(7)  NOT NULL', /*CelDial Customer Number */
      ',SHIPID        CHAR(2)  NOT NULL', /*Ship location identifier*/
      ',INVDATE       DATE     NOT NULL', /*Invoice Date            */
      ',BAL30         DECIMAL(9,2)',      /*30 Day Balance          */
      ',BAL60         DECIMAL(9,2)',      /*60 Day Balance          */
      ',BAL90         DECIMAL(9,2)',      /*90 Day Balance          */
      ',RECEIVED      DATE',              /*Payment Received Date   */
      ',RECEIVE       DECIMAL(9,2)',      /*Payment Amount          */
      ||fkey ,
      ||'  )'                             /*end-of-table def        */
    call tabcreat
    return

COMPONENTS:
    tbl='COMPONENTS'
    if reflast='REFLAST' then pkey=''
       else pkey =',PRIMARY KEY (COMPNO)'
    tbldef='CREATE TABLE COMPONENTS (',
      ' COMPNO        CHAR(6)  NOT NULL', /*Component Number         */
      ',COMPDESC      CHAR(20) NOT NULL', /*Description              */
      ',COST          DECIMAL(7,2)',      /*Component Cost           */
      ',COSTOLD       DECIMAL(7,2)',      /*Component Cost - Previous*/
      ||pkey ,
      ||'  )'                             /*end-of-table def         */
    call tabcreat

    tbl='PRODCOMP'
    if reflast='REFLAST' then parse value '' with fkey fkey2
       else do
               fkey =',FOREIGN KEY COMPFK1 (PARTNO,MODEL) REFERENCES PRODUCT ON DELETE RESTRICT'
               fkey2=',FOREIGN KEY COMPFK2 (COMPNO) REFERENCES COMPONENTS ON DELETE RESTRICT'
               end
    tbldef='CREATE TABLE PRODCOMP (',
      ' PARTNO        CHAR(5)  NOT NULL', /*Part Number              */
      ',MODEL         CHAR(5)  NOT NULL', /*Model Number             */
      ',COMPNO        CHAR(6)  NOT NULL', /*Component Number         */
      ',UNITS         SMALLINT',          /*How many used in product */
      ||fkey ,
      ||fkey2 ,
      ||'  )'                             /*end-of-table def         */
    call tabcreat

    tbl='PRODBOM'
    tbldef='CREATE VIEW PRODBOM',
      ' AS SELECT X.COMPNO, COMPDESC, COST, COSTOLD',
      '          ,Y.PARTNO, MODEL, UNITS',
      '      FROM COMPONENTS X, PRODCOMP Y',
      '     WHERE X.COMPNO = Y.COMPNO'
    dropsave = drop
    drop = '.'      /* Don't drop VIEW, if tables dropped, VIEWS are gone */
    call tabcreat
    drop = dropsave

    return

/************ Common Subroutines ******************/
tabcreat: /* expects tbl to be set */
   if drop = 'DROP' then
   do;
      say; say 'Dropping' tbl 'table, if it exists'
      call DBM '-O DROP   TABLE' tbl
      end /* do */
   say
   say 'Creating' tbl 
   rc=0
   call DBM tbldef
   if rc<>0 then do;
      say; say tbl 'table create failed, correct & restart'
      call commerr
      end
   say 'Granting SELECT to PUBLIC';
   call DBM 'GRANT SELECT ON' tbl 'TO PUBLIC'
   if rc<>0 then do;
      say; say 'GRANT failed, correct & restart'
      signal commerr
      end
   return

commerr:
    call beep 524,150;
    call beep 262,300;
    exitrc = 8
    signal commexit
