/* Populate CelDial tables with data from supplied data files */
/*************************************************************************
   Written by Steve Goldwasser, Marketing Development & Sales,
              PRGS Toronto Laboratory
              February 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Jun 8 - add PRODINV table
 * Mar 8 - add date conversions & RUNSTATS
 *************************************************************************/
 arg nolog nexttab del format debug
/************************************************
  Initialize required variables
 ************************************************/
 celdata = 'CELDIAL.DAT'  /* Consolidated data file */
 if format<>'' & format<>'.' then celdata='CELDIAL.'format
 True=(1=1); False=(0=1)
 exitrc = 0
 if debug='DEBUG' then debug=true
 else debug=false
/* Sequence of these must match the header record sequence in file */
 tab.1='CUSTOMER'   /* custfile='CELDIAL.CUS' Customer   data   */
 tab.2='PRODUCT'    /* prodfile='CELDIAL.PRD' Product    data   */
 tab.3='COMPONENTS' /* cmpfile ='CELDIAL.CMP' Components data   */
       /* rtn includes bomfile ='CELDIAL.BOM' Bill-of-Material  */
 tab.4='ORDERS'     /* ordfile ='CELDIAL.ORD' Order      data   */
 tab.5='ARHIST'     /* arfile  ='CELDIAL.AR'  AR_HIST    data   */
 tab.6='BITMAPS'    /* bitfile ='CELDIAL.BIT' Product picture list */
                    /* Format is PARTNO filename                */
 tab.0=6            /* No of data headers defined    */
 maxmdl = 4         /* Limit number of models/partno */
                    /* Extra models are discarded    */
line=' '            /* current input record value    */
/**************************************************************
   Register SQLEXEC routine
 **************************************************************/
 If Rxfuncquery('SQLEXEC') <>0 then
    do; rcy = Rxfuncadd('SQLEXEC','SQLAR','SQLEXEC')
    /*  say 'RC from Rxfuncadd is' rcy   */
        end
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
 if nolog <> 'NOLOG' then call connect
 else  say 'Skipped LOGON & CONNECT'

Recno=0             /* No of records read */
do tbnum = 1 to tab.0
   if (nexttab = '' | nexttab = '.' | nexttab = tab.tbnum) then ,
   do; call tabpos(tab.tbnum)
       if exitrc=0 then ,
          do; interpret 'call' tab.tbnum
              if exitrc<>0 then leave
              end
       else leave
       end
   end

commexit:
   say
   say 'Records read from 'celdata' = 'Recno
   say '   (includes headers, comments, & EOF record)'
   exit exitrc
/*************end-of-mainline *********************/

connect:
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
'@ECHO OFF';
 say 'Logging on as USERID locally'
'LOGON USERID /L /P='
 if rc<>0 then do;
    say 'Logon failed, RC='rc', fix & restart'
    exit 8
    end

 say 'Connecting to CELDIAL database'
 call DBM '-O CONNECT TO CELDIAL'
 if rc<>0 then do;
    say 'Connect failed, RC='rc', fix & restart'
    exit 8
    end
 return

tabpos:   /* Position to header for specified table(s) */
   arg header
   if debug then say 'Looking for header' header
   hdrnomatch = true
   do forever
      if length(line)<>0 then ,
         if substr(line,1,2) = '..' then ,
            do; parse value line with '..' headin .
                if headin = header then
                   do; hdrnomatch = false
                       leave
                       end
                else nop   /* probably redundant */
                end
         else nop
      else leave            /* EOF - quit trying */
      line=linein(celdata)  /* next line */
      Recno=Recno+1
      end /* do forever */
   if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
   if hdrnomatch then ,
      do; say 'Expected header ..'header' not found before EOF'
          say 'Correct data and rerun'
          exitrc = 8
          end
   if debug then say header Recno
   return exitrc

CUSTOMER: /* Fill CUSTOMER & CUSTSHIP tables */
 if debug then say 'Entered CUSTOMER routine, Recno='Recno
 say
 say 'Loading CUSTOMER & CUSTSHIP tables...'
 if del = 'DEL' then ,
 do;
     imm='DELETE FROM CUSTSHIP'
     call immed
     imm='DELETE FROM CUSTOMER'
     call immed
     end
 custo=0             /* CUSTOMER rows inserted */
 shipo=0             /* CUSTSHIP rows inserted */
 LastRectype='0'
 parse value 'ADDR CITY CTRY ZIP ZLOC' with L.1 L.2 L.3 L.4 L.5
 do i=1 to 5
    interpret 'CON'L.i  '='''''
    interpret 'call fillid ''CON'L.i''''
    interpret 'BILL'L.i '='''''
    interpret 'call fillid ''BILL'L.i''''
    end
/* SQL sequence - PREPARE input statement for each
                  EXECUTE statement as required using host vars
*/
 Custinsert = 'INSERT INTO CUSTOMER VALUES(?,?,?,?,?,?,?,?,?,?,?)'
 Shipinsert = 'INSERT INTO CUSTSHIP VALUES(?,?,?,?,?,?,?,?,?,?,?,?)'
 call SQLEXEC 'PREPARE S1 from :Custinsert'
 call SQLEXEC 'PREPARE S2 from :Shipinsert'

 rowctr = 0
/* CUSTOMER data Input loop                  */
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then ,
      do; if LastRectype = '3' then call shipout /* process last ship-to rec */
          leave
          end
    if substr(line,1,2)='.*' then iterate  /* bypass comments */
    Rectype = substr(line,1,1)
    select;
      when Rectype = '1' then
        do;
            if LastRectype = '1' then call contout /* insert incomplete CUSTOMER */
            if LastRectype = '3' then call shipout /* insert padded CUSTSHIP     */
            CUSTNO   = ''''substr(line,3,7)''''
            CUSTNAME = ''''substr(line,11,40)''''
            REPNO    = substr(line,52,5) ; call fillid 'REPNO'
            CONTACT  = substr(line,58,25); call fillid 'CONTACT'
            CONPHONE = substr(line,84,17); call fillid 'CONPHONE'
            CONFAX   =substr(line,102,17); call fillid 'CONFAX'
            LastRectype = Rectype
            end   /* Rectype = 1 */
      when Rectype = '2' then
        do;
            if LastRectype = '3' then call shipout /* insert padded CUSTSHIP     */
            call parsaddr
            do i=1 to 5
               interpret 'CON'L.i'='L.i
               interpret 'call fillid ''CON'L.i''''
               end
            call contout
            LastRectype = Rectype
            end   /* Rectype = 2 */
      when Rectype = '3' then
        do;
            if LastRectype = '3' then call shipout /* insert padded CUSTSHIP     */
            call parsaddr
            do i=1 to 5
               interpret 'SHIP'L.i'='L.i
               interpret 'call fillid ''SHIP'L.i''''
               end
            LastRectype = Rectype
            end   /* Rectype = 3 */
      when Rectype = '4' then
        do;
            call parsaddr
            do i=1 to 5
               interpret 'BILL'L.i'='L.i
               interpret 'call fillid ''BILL'L.i''''
               end
            call shipout
            LastRectype = Rectype
            end   /* Rectype = 4 */
      otherwise
        do; say 'Unknown record type' Rectype 'read at recno' Recno
            say 'Repair data & rerun'
            call abort
            end /* otherwise */
      end  /* Select */
    end /* do forever*/
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'CUSTOMER rows inserted ='custo
 say 'CUSTSHIP rows inserted ='shipo
/* Close off as required, and */
 call commit
 return
/*************end-of-fillcust routine******************/

PRODUCT: /* Fill PRODUCT table */
 if debug then say 'Entered PRODUCT routine, Recno='Recno
 say
 say 'Loading PRODUCT, PRODSHOW, & PRODINV tables'
 if del = 'DEL' then ,
 do; /* empty the tables first */
     imm='DELETE FROM PRODUCT'
     call immed
     imm='DELETE FROM PRODSHOW'
     call immed
     imm='DELETE FROM PRODINV'
     call immed
     end
 parse value '0 0' with prodshowo producto prevpart  /*init*/
/* SQL sequence - PREPARE input statements
                  EXECUTE statements as required using host vars
*/
 Showinsert = 'INSERT INTO PRODSHOW (PARTNO,PARTDESC) VALUES(?,?)'
 Prodinsert = 'INSERT INTO PRODUCT VALUES(?,?,?,?,?,?)'
 Invinsert  = 'INSERT INTO PRODINV VALUES(?,?,?,?,?)'
 call prep 'S1' 'Showinsert'
 call prep 'S2' 'Prodinsert'
 call prep 'S3' 'Invinsert'
 mdlcnt = 0 /* compare to maxmdl for limit */
/* PRODUCT data Input loop */
 rowctr=0
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    if substr(line,1,2)='.*' then iterate  /* bypass comment lines */
    PARTNO      = "'"substr(line,1,5)"'"
    PARTDESC    = "'"substr(line,7,20)"'"
    MODEL       = "'"substr(line,29,5)"'"
    PARTPRICE   = substr(line,47,8)
    PARTMSR     = substr(line,38,8)
    PARTDISC    = substr(line,56,1)
    PARTSHIPDATE= "'"substr(line,58,10)"'"
    INVENTORY   = substr(line,80,4)
    RESTOCK     = substr(line,86,4)
    RESTOCK_LEAD_DAYS=substr(line,94,2)
    if PARTNO <> prevpart then
    do;
        prevpart = PARTNO
        prevdesc = PARTDESC
        mdlcnt=0
        call SQLEXEC 'EXECUTE S1 USING :PARTNO,:PARTDESC'
        call chksql
        prodshowo = prodshowo + 1
    rowctr = rowctr+1
    if rowctr>49 then
       do; say 'Inserted' prodshowo+producto 'rows so far...'
             rowctr=0  /* start over */
             end
        end
    mdlcnt = mdlcnt + 1
    if mdlcnt > maxmdl then iterate
    call SQLEXEC 'EXECUTE S2 USING ',
                 ':PARTNO,:MODEL,',
                 ':PARTPRICE,:PARTMSR,:PARTDISC,:PARTSHIPDATE'
    call chksql
    call SQLEXEC 'EXECUTE S3 USING ',
                 ':PARTNO,:MODEL,',
                 ':INVENTORY,:RESTOCK,:RESTOCK_LEAD_DAYS'
    call chksql
    producto = producto + 1
    rowctr = rowctr+1
    if rowctr>49 then
       do; say 'Inserted' prodshowo+producto 'rows so far...'
             rowctr=0  /* start over */
             end
    end /* Do forever */
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'Parts  written='prodshowo
 say 'Models written='producto
 call commit
 return
/*************end-of-product routine*******************/

ORDERS: /* Fill Order & History tables - summary & history*/
 if debug then say 'Entered ORDERS routine, Recno='Recno
 say
 say 'Loading order & order-history tables'
 if del = 'DEL' then ,
 do ; /* Empty the tables first, ignore errors */
      imm='DELETE FROM ORDER_DETAIL'
      call immed
      imm='DELETE FROM ORDER_SUMMARY'
      call immed
      imm='DELETE FROM ORDER_HIST_DET'
      call immed
      imm='DELETE FROM ORDER_HIST_SUM'
      call immed
      end
 parse value '0 0 0 0' with ordO1 ordO2 ordH1 ordH2
/* SQL sequence - PREPARE input statements
                  EXECUTE statements as required using host vars
*/
 Ordsinsert = 'INSERT INTO ORDER_SUMMARY VALUES(?,?,?,?,?,?,?,?)'
 Orddinsert = 'INSERT INTO ORDER_DETAIL  VALUES(?,?,?,?,?)'
 Hissinsert = 'INSERT INTO ORDER_HIST_SUM VALUES(?,?,?,?,?,?,?,?)'
 Hisdinsert = 'INSERT INTO ORDER_HIST_DET VALUES(?,?,?,?,?)'
 call prep 's1' 'Ordsinsert'
 call prep 's2' 'Orddinsert'
 call prep 's3' 'Hissinsert'
 call prep 's4' 'Hisdinsert'

/* Order data Input loop */
 rowctr=0
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    if substr(line,1,2)='.*' then iterate  /* bypass comment lines */
    rt = substr(line,3,2)
    rectypeOH = substr(line,3,1)
    rectype12 = substr(line,4,1)
    ORDERREF = "'"substr(line,6,5)"'"  /* common to all record types */
    if rectype12 = '1' then ,
    do; CUSTNO       = "'"substr(line,12,7)"'"
        SHIPID       = "'"substr(line,20,2)"'"
        ORDERDATE    = "'"substr(line,23,10)"'"
        CUSTSHIPDATE = "'"substr(line,34,10)"'"
        PLANSHIPDATE = "'"substr(line,45,10)"'"
        STATUS       = "'"substr(line,56,2)"'"   /* for Orders     */
        ACTSHIPDATE  = "'"substr(line,56,10)"'"  /* for History    */
        COMMENTS     = "'"substr(line,67,19)"'"
        if rectypeOH = 'O' then ,
             do; stmt = 'S1' ; STAT = STATUS; end
        else do; stmt = 'S3' ; STAT = ACTSHIPDATE; end
        if COMMENTS = "'                  '" ,
        then commind = -1
        else commind = 18
/*      say 'Inserting' rt ORDERREF CUSTNO SHIPID '|'COMMENTS'|' */
        interpret "call SQLEXEC 'EXECUTE "stmt" USING ",
                     ":ORDERREF, :CUSTNO, :SHIPID,",
                     ":ORDERDATE, :CUSTSHIPDATE,",
                     ":PLANSHIPDATE, :STAT, :COMMENTS:commind'"
        call chksql
        end
    else do; /* type 2 - order or order history detail */
        PARTNO    = "'"substr(line,12,5)"'"
        MODEL     = "'"substr(line,18,5)"'"
        PARTPRICE =    substr(line,24,8)
        UNITS     =    substr(line,33,2)
        if rectypeOH = 'O' then stmt ='S2'
                           else stmt ='S4'
/*      say 'Inserting' rt ORDERREF PARTNO MODEL    */
        interpret "call SQLEXEC 'EXECUTE "stmt" USING ",
                           ":ORDERREF, :PARTNO, :MODEL, :PARTPRICE, :UNITS'"
        call chksql
        end
    interpret 'ord'rt '= ord'rt'+1'
    rowctr = rowctr+1
    if rowctr>49 then
       do; say 'Inserted' ordO1+ordO2+ordH1+ordH2 'rows, so far...'
             rowctr=0  /* start over */
             end

    end /* Do forever */
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'Order sum recs inserted='ordO1
 say 'Order det recs inserted='ordO2
 say 'Hist  sum recs inserted='ordH1
 say 'Hist  det recs inserted='ordH2
 call commit
 return
/*************end-of-order routine*********************/
ARHIST:   /* AR History */
 if debug then say 'Entered ARHIST routine, Recno='Recno
 say
 say 'Inserting Accounts-Receivable History rows'

 if del = 'DEL' then ,
 do ; /* Empty the table first */
      imm='DELETE FROM AR_HISTORY'
      call immed
      end
 arcnt = 0
/* SQL sequence - PREPARE input statements
                  EXECUTE statements as required using host vars
*/
 ARinsert = 'INSERT INTO AR_HISTORY VALUES(?,?,?,?,?,?,?,?)'
 call prep 's1' 'ARinsert'

/* AR data Input loop */
 rowctr=0
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    if substr(line,1,2)='.*' then iterate  /* bypass comment lines */
    CUSTNO   = "'"substr(line,3,7)"'"
    SHIPID   = "'"substr(line,11,2)"'"
    INVDATE  = "'"substr(line,14,10)"'"
    BAL30    =    substr(line,25,5)
    BAL60    =    substr(line,31,5)
    BAL90    =    substr(line,37,5)
    RECEIVED = "'"substr(line,43,10)"'"
    RECEIVE  =    substr(line,54,5)
    call SQLEXEC 'EXECUTE S1 USING ',
         ':CUSTNO,:SHIPID,:INVDATE,:BAL30,:BAL60,:BAL90,:RECEIVED,:RECEIVE'
    call chksql
    arcnt = arcnt+1
    rowctr = rowctr+1
    if rowctr>49 then
       do; say 'Inserted' arcnt 'rows, so far'
             rowctr=0  /* start over */
             end
    end /* Do forever */
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'AR History rows inserted='arcnt
 call commit
 return
/*************end-of-AR_HIST routine*******************/

COMPONENTS:   /* Components & Prodcomp tables */
 if debug then say 'Entered COMPONENTS routine, Recno='Recno
 say
 say 'Inserting component rows'
 if del = 'DEL' then ,
 do ; /* Empty the tables first */
      say 'Emptying tables'
      imm='DELETE FROM PRODCOMP'
      call immed
      imm='DELETE FROM COMPONENTS'
      call immed
      end
 cmpcnt = 0  /* COMPONENT table rows inserted */
/* SQL sequence - PREPARE input statements
                  EXECUTE statements as required using host vars
*/
 cmpinsert = 'INSERT INTO COMPONENTS VALUES(?,?,?,?)'
 call prep 's1' 'cmpinsert'

/* cmp data input loop */
 rowctr=0
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    if substr(line,1,2)='.*' then iterate  /* bypass comment lines */
    COMPNO      = "'"substr(line,23,6)"'"
    COMPDESC    = "'"substr(line,1,20)"'"
    COST    =        substr(line,32,5)
    COSTOLD =        substr(line,38,5)
    call SQLEXEC 'EXECUTE S1 USING ',
         ':COMPNO,:COMPDESC,:COST,:COSTOLD'
    call chksql
    cmpcnt = cmpcnt+1
    rowctr = rowctr+1
    if rowctr>49 then
       do; say 'Inserted' cmpcnt 'rows, so far...'
             rowctr=0  /* start over */
             end
    end /* Do forever */
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'Total Component rows inserted='cmpcnt
 call commit

 call tabpos('BOM')  /* Validate next header */
 if exitrc <> 0 then return
 if debug then say 'Loading PRODCOMP, Recno='Recno
 say
 say 'Inserting BOM rows'
 bomcnt = 0   /* PRODCOMP  table rows inserted */
 prevpart=' ' /* previous partno              */
 prevmdl =' ' /* previous model               */
/* SQL sequence - PREPARE input statements
                  EXECUTE statements as required using host vars
*/
 bominsert = 'INSERT INTO PRODCOMP VALUES(?,?,?,?)'
 call prep 's1' 'bominsert'
 prdupdate = 'UPDATE PRODUCT SET PARTPRICE=?,PARTMSR=?',
             ' WHERE PARTNO=? AND MODEL=?'
 call prep 's2' 'prdupdate'

/* bom data input loop */
 rowctr=0
 do forever;
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    if substr(line,1,2)='.*' then iterate  /* bypass comment lines */
    PARTNO = "'"substr(line,1,5)"'"
    MODEL  = "'"substr(line,7,5)"'"
    if PARTNO = prevpart then ,
       if MODEL <> prevmdl then ,
         do; mdlcnt = mdlcnt+1
             prevmdl = MODEL
             end
       else nop
    else do; prevpart = PARTNO
             prevmdl  = MODEL
             mdlcnt   = 1
             end
    if mdlcnt > maxmdl then iterate  /* skip if too many models */
    COMPNO = "'"substr(line,13,6)"'"
    if COMPNO<>"'*TCOST'" then ,
      do; UNITS  =    substr(line,20,2)
          call SQLEXEC 'EXECUTE S1 USING ',
                       ':PARTNO,:MODEL,:COMPNO,:UNITS'
          call chksql
          bomcnt = bomcnt+1
          rowctr = rowctr+1
          if rowctr>49 then
             do; say 'Inserted' bomcnt 'rows, so far...'
                 rowctr=0  /* start over */
                 end
          end
    else do;  /* COMPNO = '*TCOST' */
          parse value line with . '-'partdisc . PARTPRICE
          partdisc = partdisc+10
          /* price has $25 assembly/overhead cost, double total cost for profit*/
          PARTPRICE = format(50+(PARTPRICE*2),,2)
          /* Markup retail price with same formula used to gen data */
          PARTMSR   = format(PARTPRICE/(1-(partdisc/100)),,2)
          call SQLEXEC 'EXECUTE S2 USING ',
                       ':PARTPRICE,:PARTMSR,:PARTNO,:MODEL'
          say 'Updated' PARTNO MODEL 'with prices' PARTPRICE PARTMSR
          end  /* Do */
    end /* Do forever */
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 say
 say 'BOM rows inserted='bomcnt
 call commit
 return
/*************end-of-COMPONENTS routine*************/

BITMAPS:
 if debug then say 'Entered BITMAPS routine, Recno='Recno
 say
 say 'Loading bitmaps to PRODUCT descriptions'
 if del = 'DEL' then ,
 do; say 'Empty the bitmaps first'
     imm='UPDATE PRODSHOW SET PARTPIC=NULL'
     call immed
     call chksql
     end
 prdupdate = 'UPDATE PRODSHOW SET PARTPIC=? WHERE PARTNO=?'
 call prep 's1' 'prdupdate'
 Bitcnt = 0
 do forever
    line=linein(celdata)
    Recno=Recno+1
    if (length(line)=0 | substr(line,1,2)='..') then leave
    /* Format is PARTNO filename */
    if substr(line,1,1)='*' then iterate  /* bypass comment lines */
    parse value line with partval file rest
    partval = "'"partval"'"
    if debug then say partval rest
    status=stream(file,'C','QUERY EXISTS')
    if status <>'' then ,
      do
         size=stream(file,'C','QUERY SIZE')
         status = stream(file,'C','OPEN READ')
         if status='READY:' then ,
           do
              bitmap=charin(file,1,size)
              bitmap="'"bitmap"'"
              status=stream(file,'C','CLOSE')
              if debug then say 'Loading PARTNO=' partval 'with bitmap in' file
              call SQLEXEC 'EXECUTE S1 USING :bitmap,:partval'
              call chksql
              if debug then say 'Bitmap' file 'installed for part' partval
              Bitcnt = Bitcnt + 1
              end /* do */
         else do; say 'File' file 'OPEN READ status is' status
                  status = stream(file,'C','CLOSE')
                  call abort
                  end
         end
    else say 'File' file 'not found to load into part' partval
    end /* do forever*/
 if length(line)=0 then Recno = Recno-1 /* adjust for EOF */
 status = stream(file,'C','CLOSE')
 say 'Bitmaps loaded =' Bitcnt
 call commit
 return
/*************end-of-BITMAPS routine****************/

 contout: /* Output CUSTOMER row built & re-init CONTACT variables */
      call SQLEXEC 'EXECUTE S1 USING ',
                   ':CUSTNO,:CUSTNAME,:REPNO:REPNOID,',
                   ':CONTACT:CONTACTID,',
                   ':CONPHONE:CONPHONEID,',
                   ':CONFAX:CONFAXID,',
                   ':CONADDR:CONADDRID,',
                   ':CONCITY:CONCITYID,',
                   ':CONCTRY:CONCTRYID,',
                   ':CONZIP:CONZIPID,',
                   ':CONZLOC:CONZLOCID'
      call chksql
      custo = custo+1
      rowctr = rowctr+1
      if rowctr>49 then
         do; say 'Inserted' custo+shipo 'rows, so far...'
             rowctr=0  /* start over */
             end

/*  Reset CUSTOMER variables */
          SHIPID=0
          CONADDR=''; CONADDRID=-1
          CONCITY=''; CONCITYID=-1
          CONCTRY=''; CONCTRYID=-1
          CONZIP =''; CONZIPID =-1
          CONZLOC=''; CONZLOCID=-1
         return

 shipout: /* Output CUSTSHIP row built & re-init BILLTO variables */
      SHIPID = SHIPID + 1
      SHIPIDSTR = "'"right('0'SHIPID,2)"'"
      if Rectype<>'4' then
         do i=1 to 5; /* Assume Bill-to address = Ship-to address */
            interpret 'BILL'L.i'=SHIP'L.i
            interpret 'BILL'L.i'ID=SHIP'L.i'ID'
         end /* do */
      call SQLEXEC 'EXECUTE S2 USING ',
                   ':CUSTNO,:SHIPIDSTR,',
                   ':SHIPADDR:SHIPADDRID,',
                   ':SHIPCITY:SHIPCITYID,',
                   ':SHIPCTRY:SHIPCTRYID,',
                   ':SHIPZIP:SHIPZIPID,',
                   ':SHIPZLOC:SHIPZLOCID,',
                   ':BILLADDR:BILLADDRID,',
                   ':BILLCITY:BILLCITYID,',
                   ':BILLCTRY:BILLCTRYID,',
                   ':BILLZIP:BILLZIPID,',
                   ':BILLZLOC:BILLZLOCID'
      call chksql
      shipo = shipo + 1
      rowctr = rowctr+1
      if rowctr>49 then
         do; say 'Inserted' custo+shipo 'rows, so far...'
             rowctr=0  /* start over */
             end
      return

parsaddr: /* Common routine to break up address line */
      ADDR = substr(line,3,40)
      CITY = substr(line,44,30)
      CTRY = substr(line,75,20)
      ZIP  = substr(line,96,10)
      ZLOC = substr(line,107,1)
      return

fillid:
    parse arg vbl
    interpret 'if' vbl '= '''' then ' vbl'ID =-1; else' vbl'ID = length('vbl')'
    interpret vbl '= "''"'vbl'"''"'
    return

prep:
    parse arg Sn imm
    if debug then say 'PREPAREing' imm
    interpret "call SQLEXEC 'PREPARE" Sn  "from :"imm"'"
    call chksql
    return

commit:
    call SQLEXEC 'COMMIT'
    if debug then do; say 'Pause to see numbers...'; pull .; end
    return

abort:
    call SQLEXEC 'ROLLBACK WORK'
    exitrc = 8
    return

immed:
    call SQLEXEC 'EXECUTE IMMEDIATE :imm'
    return

chksql:
    if SQLCA.SQLCODE <> 0 then ,
      do; say SQLMSG
          say Recno
          call abort
          exit exitrc
          end
    return
