@echo off
rem This batch file will flag all DCS database and executable files
rem as "Shareable" on a Novell network.  This must be done after
rem the initial install AND after any projects are added.
rem
rem The Novell flag utility must be in the current path.
rem
rem The dcs 'root' directory must be passed as the first parameter.
rem This batch file is usually invoked by the program manager icon
rem which was created for it as part of the setup process.

rem
rem Make sure they entered a path
rem

if "%1" == "" goto err

rem
rem Verify path is the dcs root
rem

if not exist %1\bin\setup.exe goto badpath

rem
rem flag the easy stuff
rem

flag %1\bin +S /C
flag %1\clone +S /C
flag %1\help +S /C
flag %1\sys +S /c

rem
rem flag any project databases which are present
rem

flag %1\db +S sub /C

cls
echo.
echo DCS Flag complete
echo.

goto end

:err
echo.
echo ERROR: YOU ARE NOT USING DCSFLAG PROPERLY.
echo.
echo The DCSFLAG command will mark all DCS files as shareable on Novell
echo Networks. The DCS 'root' directory must be specified as the first
echo and only parameter.  For this reason this batch file is usually
echo invoked by the program manager icon created for it as part of the
echo DCS installation.
echo.
echo Note that the Novell flag utility must be in the current path.
echo.
echo DCSFLAG is exiting now...
echo.
goto end

:badpath
echo.
echo The DCS 'root' directory you specified is not correct.
echo.
echo Correct the problem and rerun DCSFLAG.
echo.
echo DCSFLAG is exiting now...
echo.
goto end

:end
if not exist %1\bin\dcstest.flg pause
